/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.converter.model;

import com.google.common.base.Preconditions;
import java.util.List;
import org.raml.api.RamlApi;
import org.raml.api.RamlMediaType;
import org.raml.api.RamlResource;
import org.raml.api.RamlSupportedAnnotation;
import org.raml.jaxrs.converter.RamlConfiguration;
import org.raml.jaxrs.converter.model.Utilities;
import org.raml.jaxrs.model.JaxRsApplication;

public class JaxRsRamlApi
implements RamlApi {
    private final RamlConfiguration configuration;
    private final JaxRsApplication application;

    private JaxRsRamlApi(RamlConfiguration configuration, JaxRsApplication application) {
        this.configuration = configuration;
        this.application = application;
    }

    public static JaxRsRamlApi create(RamlConfiguration configuration, JaxRsApplication application) {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)application);
        return new JaxRsRamlApi(configuration, application);
    }

    public String getTitle() {
        return this.configuration.getTitle();
    }

    public String getVersion() {
        return this.configuration.getVersion();
    }

    public String getBaseUri() {
        return this.configuration.getBaseUri();
    }

    public List<RamlResource> getResources() {
        return Utilities.toRamlResources(this.application.getResources()).toList();
    }

    public RamlMediaType getDefaultMediaType() {
        return this.configuration.getDefaultMediaType();
    }

    public List<RamlSupportedAnnotation> getSupportedAnnotation() {
        return Utilities.toRamlSupportedAnnotation(this.application.getSupportedAnnotations()).toList();
    }

    public String getTopPackage() {
        return this.application.getTopPackage();
    }
}

