/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.plugin;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import java.io.File;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.raml.emitter.RamlEmissionException;
import org.raml.jaxrs.converter.JaxRsToRamlConversionException;
import org.raml.jaxrs.converter.RamlConfiguration;
import org.raml.jaxrs.parser.JaxRsParsingException;
import org.raml.jaxrs.plugin.PluginConfiguration;
import org.raml.jaxrs.raml.core.DefaultRamlConfiguration;
import org.raml.jaxrs.raml.core.OneStopShop;

@Mojo(name="jaxrstoraml", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class JaxRsToRamlMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}")
    private MavenProject project;
    @Parameter(property="jaxrs.to.raml.input", defaultValue="${project.build.outputDirectory}")
    private File input;
    @Parameter(property="jaxrs.to.raml.sourceDirectory", defaultValue="${project.build.sourceDirectory}")
    private File sourceDirectory;
    @Parameter(property="jaxrs.to.raml.outputFileName", defaultValue="${project.artifactId}.raml")
    private String outputFileName;
    @Parameter(property="jaxrs.to.raml.outputDirectory", defaultValue="${project.build.directory}/generated-sources/raml-jaxrs")
    private File outputDirectory;
    @Parameter(property="jaxrs.to.raml.translatedAnnotations")
    private List<String> translatedAnnotations = new ArrayList<String>();
    @Parameter(property="jaxrs.to.raml.topPackage")
    private String topPackage;

    public void execute() throws MojoExecutionException, MojoFailureException {
        PluginConfiguration configuration = this.createConfiguration();
        JaxRsToRamlMojo.confinedExecute(configuration, this.getLog());
        this.project.addCompileSourceRoot(this.outputDirectory.getPath());
    }

    private static void confinedExecute(PluginConfiguration configuration, Log logger) throws MojoExecutionException {
        JaxRsToRamlMojo.checkConfiguration(configuration);
        JaxRsToRamlMojo.printConfiguration(configuration, logger);
        Path jaxRsUrl = configuration.getInput();
        Path sourceCodeRoot = configuration.getSourceDirectory();
        configuration.getOutputDirectory().toFile().mkdirs();
        Path finalOutputFile = configuration.getOutputDirectory().resolve(configuration.getRamlFileName());
        String applicationName = FilenameUtils.removeExtension((String)configuration.getRamlFileName().getFileName().toString());
        DefaultRamlConfiguration ramlConfiguration = DefaultRamlConfiguration.forApplication((String)applicationName, (Set)FluentIterable.from(configuration.getTranslatedAnnotations()).transform((Function)new Function<String, Class<? extends Annotation>>(){

            @Nullable
            public Class<? extends Annotation> apply(@Nullable String input) {
                try {
                    return Class.forName(input);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("invalid class " + input, e);
                }
            }
        }).toSet(), (String)configuration.getTopPackage());
        OneStopShop oneStopShop = OneStopShop.builder().withJaxRsClassesRoot(jaxRsUrl).withSourceCodeRoot(sourceCodeRoot).withRamlOutputFile(finalOutputFile).withRamlConfiguration((RamlConfiguration)ramlConfiguration).build();
        try {
            oneStopShop.parseJaxRsAndOutputRaml();
        }
        catch (RamlEmissionException | JaxRsToRamlConversionException | JaxRsParsingException e) {
            throw new MojoExecutionException(String.format("unable to generate output raml file: %s", finalOutputFile), (Exception)e);
        }
    }

    private PluginConfiguration createConfiguration() {
        return PluginConfiguration.create(this.getInputPath(), this.getSourceDirectoryPath(), this.getOutputDirectoryPath(), this.getRamlFileName(), this.translatedAnnotations, this.topPackage);
    }

    private static void printConfiguration(PluginConfiguration configuration, Log logger) {
        logger.info((CharSequence)"Configuration");
        logger.info((CharSequence)String.format("input: %s", configuration.getInput()));
        logger.info((CharSequence)String.format("source directory: %s", configuration.getSourceDirectory()));
        logger.info((CharSequence)String.format("output directory: %s", configuration.getOutputDirectory()));
        logger.info((CharSequence)String.format("output file name: %s", configuration.getRamlFileName()));
    }

    private static void checkConfiguration(PluginConfiguration configuration) throws MojoExecutionException {
        JaxRsToRamlMojo.checkInputFile(configuration.getInput());
    }

    private static void checkInputFile(Path inputPath) throws MojoExecutionException {
        if (!Files.isRegularFile(inputPath, new LinkOption[0]) && !Files.isDirectory(inputPath, new LinkOption[0])) {
            throw new MojoExecutionException(String.format("invalid input file: %s", inputPath));
        }
    }

    private Path getInputPath() {
        return this.input.toPath();
    }

    private Path getSourceDirectoryPath() {
        return this.sourceDirectory.toPath();
    }

    public Path getOutputDirectoryPath() {
        return this.outputDirectory.toPath();
    }

    public Path getRamlFileName() {
        return Paths.get(this.outputFileName, new String[0]);
    }
}

