package example.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.File;
import java.util.Map;

@JsonDeserialize(
    as = MultipartPostMultipartFormDataImpl.class
)
public interface MultipartPostMultipartFormData {
  @JsonAnyGetter
  Map<String, Object> getAdditionalProperties();

  @JsonAnySetter
  void setAdditionalProperties(String key, Object value);

  @JsonProperty("appBundle")
  File getAppBundle();

  @JsonProperty("appBundle")
  void setAppBundle(File appBundle);

  @JsonProperty("configFile")
  File getConfigFile();

  @JsonProperty("configFile")
  void setConfigFile(File configFile);

  @JsonProperty("consumed")
  User getConsumed();

  @JsonProperty("consumed")
  void setConsumed(User consumed);

  @JsonProperty("heyBool")
  boolean getHeyBool();

  @JsonProperty("heyBool")
  void setHeyBool(boolean heyBool);
}
