package example.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.File;
import java.util.Map;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "appBundle",
    "configFile",
    "consumed",
    "heyBool"
})
public class MultipartPostMultipartFormDataImpl implements MultipartPostMultipartFormData {
  @JsonProperty("appBundle")
  private File appBundle;

  @JsonProperty("configFile")
  private File configFile;

  @JsonProperty("consumed")
  private User consumed;

  @JsonProperty("heyBool")
  private boolean heyBool;

  @JsonIgnore
  private Map<String, Object> additionalProperties = new ExcludingMap();

  @JsonProperty("appBundle")
  public File getAppBundle() {
    return this.appBundle;
  }

  @JsonProperty("appBundle")
  public void setAppBundle(File appBundle) {
    this.appBundle = appBundle;
  }

  @JsonProperty("configFile")
  public File getConfigFile() {
    return this.configFile;
  }

  @JsonProperty("configFile")
  public void setConfigFile(File configFile) {
    this.configFile = configFile;
  }

  @JsonProperty("consumed")
  public User getConsumed() {
    return this.consumed;
  }

  @JsonProperty("consumed")
  public void setConsumed(User consumed) {
    this.consumed = consumed;
  }

  @JsonProperty("heyBool")
  public boolean getHeyBool() {
    return this.heyBool;
  }

  @JsonProperty("heyBool")
  public void setHeyBool(boolean heyBool) {
    this.heyBool = heyBool;
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  @JsonAnySetter
  public void setAdditionalProperties(String key, Object value) {
    this.additionalProperties.put(key, value);
  }
}
