package example.types;

import example.model.Human;
import example.support.ResponseDelegate;
import java.lang.Object;
import java.lang.String;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path("/humans")
public interface Humans {
  @GET
  @Produces("application/json")
  GetHumansResponse getHumans(@QueryParam("type") String type);

  @GET
  @Path("/{id}")
  @Produces("application/json")
  GetHumansByIdResponse getHumansById(@PathParam("id") String id, @QueryParam("type") String type);

  @PUT
  @Path("/{id}")
  @Consumes("application/json")
  PutHumansByIdResponse putHumansById(@PathParam("id") String id, Human entity);

  class GetHumansResponse extends ResponseDelegate {
    private GetHumansResponse(Response response, Object entity) {
      super(response, entity);
    }

    private GetHumansResponse(Response response) {
      super(response);
    }

    public static GetHumansResponse respond200WithApplicationJson(List<Human> entity) {
      Response.ResponseBuilder responseBuilder = Response.status(200).header("Content-Type", "application/json");
      responseBuilder.entity(entity);
      return new GetHumansResponse(responseBuilder.build(), entity);
    }
  }

  class PutHumansByIdResponse extends ResponseDelegate {
    private PutHumansByIdResponse(Response response, Object entity) {
      super(response, entity);
    }

    private PutHumansByIdResponse(Response response) {
      super(response);
    }

    public static PutHumansByIdResponse respond200() {
      Response.ResponseBuilder responseBuilder = Response.status(200);
      return new PutHumansByIdResponse(responseBuilder.build());
    }
  }

  class GetHumansByIdResponse extends ResponseDelegate {
    private GetHumansByIdResponse(Response response, Object entity) {
      super(response, entity);
    }

    private GetHumansByIdResponse(Response response) {
      super(response);
    }

    public static GetHumansByIdResponse respond200WithApplicationJson(Human entity) {
      Response.ResponseBuilder responseBuilder = Response.status(200).header("Content-Type", "application/json");
      responseBuilder.entity(entity);
      return new GetHumansByIdResponse(responseBuilder.build(), entity);
    }
  }
}
