/*
 * Decompiled with CFR 0.152.
 */
package example.support;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import example.model.Arm;
import example.model.Leg;
import example.model.Limb;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;

public class LimbDeserializer
extends StdDeserializer<Limb> {
    public LimbDeserializer() {
        super(Limb.class);
    }

    private boolean looksLikeArm(Map<String, Object> map) {
        return map.keySet().containsAll(Arrays.asList("fingers"));
    }

    private boolean looksLikeLeg(Map<String, Object> map) {
        return map.keySet().containsAll(Arrays.asList("toes"));
    }

    public Limb deserialize(JsonParser jsonParser, DeserializationContext jsonContext) throws IOException, JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        Map map = (Map)mapper.readValue(jsonParser, Map.class);
        if (this.looksLikeArm(map)) {
            return new Limb((Arm)mapper.convertValue((Object)map, Arm.class));
        }
        if (this.looksLikeLeg(map)) {
            return new Limb((Leg)mapper.convertValue((Object)map, Leg.class));
        }
        throw new IOException("Can't figure out type of object" + map);
    }
}

