package example.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;

/**
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder("fingers")
public class ArmImpl implements Arm {
  @JsonIgnore
  private Map<String, Object> additionalProperties = new HashMap<String, Object>();

  @JsonProperty("fingers")
  @NotNull
  private int fingers;

  @JsonProperty("fingers")
  public int getFingers() {
    return this.fingers;
  }

  @JsonProperty("fingers")
  public void setFingers(int fingers) {
    this.fingers = fingers;
  }
}
