package example.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.validation.constraints.NotNull;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder("fingers")
public class ArmImpl implements Arm {
  @JsonProperty(
      value = "fingers",
      defaultValue = "5"
  )
  @NotNull
  private Integer fingers;

  @JsonIgnore
  private Map<String, Object> additionalProperties = new HashMap<String, Object>();

  @JsonProperty(
      value = "fingers",
      defaultValue = "5"
  )
  public Integer getFingers() {
    return this.fingers;
  }

  @JsonProperty(
      value = "fingers",
      defaultValue = "5"
  )
  public void setFingers(Integer fingers) {
    this.fingers = fingers;
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  @JsonAnySetter
  public void setAdditionalProperties(String key, Object value) {
    this.additionalProperties.put(key, value);
  }

  @Override
  public boolean equals(Object o) {
    if (o == null) return false;
    if (this == o) return true;
    if (getClass() != o.getClass()) return false;
    ArmImpl other = (ArmImpl) o;
    return java.util.Objects.equals(this.fingers, other.fingers) && java.util.Objects.equals(this.additionalProperties, other.additionalProperties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(fingers,additionalProperties);
  }
}
