package example.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.validation.constraints.NotNull;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonTypeName("person")
@JsonPropertyOrder({
    "humanType",
    "limbs",
    "timeOfArrival",
    "timeOfBirth",
    "dateOfBirth",
    "instantOfBirth",
    "requestTime",
    "actualGender",
    "name",
    "weight",
    "siblings"
})
public class PersonImpl implements Person {
  @JsonProperty("humanType")
  @NotNull
  private final String humanType = "person";

  @JsonProperty("limbs")
  @NotNull
  private Limb limbs;

  @NotNull
  @JsonProperty("timeOfArrival")
  @JsonFormat(
      shape = JsonFormat.Shape.STRING,
      pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSZ"
  )
  private Date timeOfArrival;

  @JsonFormat(
      shape = JsonFormat.Shape.STRING,
      pattern = "HH:mm:ss"
  )
  @NotNull
  @JsonProperty("timeOfBirth")
  private Date timeOfBirth;

  @NotNull
  @JsonProperty("dateOfBirth")
  @JsonFormat(
      shape = JsonFormat.Shape.STRING,
      pattern = "yyyy-MM-dd"
  )
  private Date dateOfBirth;

  @JsonProperty("instantOfBirth")
  @JsonFormat(
      shape = JsonFormat.Shape.STRING,
      pattern = "yyyy-MM-dd'T'HH:mm:ssZ"
  )
  @NotNull
  private Date instantOfBirth;

  @JsonFormat(
      shape = JsonFormat.Shape.STRING,
      pattern = "EEE, dd MMM yyyy HH:mm:ss z"
  )
  @NotNull
  @JsonProperty("requestTime")
  private Date requestTime;

  @NotNull
  @JsonProperty("actualGender")
  private Gender actualGender;

  @JsonProperty("name")
  @NotNull
  private String name;

  @NotNull
  @JsonProperty("weight")
  private Integer weight;

  @JsonProperty("siblings")
  @NotNull
  private List<Human> siblings;

  @JsonIgnore
  private Map<String, Object> additionalProperties = new HashMap<String, Object>();

  @JsonProperty("humanType")
  public String getHumanType() {
    return this.humanType;
  }

  @JsonProperty("limbs")
  public Limb getLimbs() {
    return this.limbs;
  }

  @JsonProperty("limbs")
  public void setLimbs(Limb limbs) {
    this.limbs = limbs;
  }

  @JsonProperty("timeOfArrival")
  public Date getTimeOfArrival() {
    return this.timeOfArrival;
  }

  @JsonProperty("timeOfArrival")
  public void setTimeOfArrival(Date timeOfArrival) {
    this.timeOfArrival = timeOfArrival;
  }

  @JsonProperty("timeOfBirth")
  public Date getTimeOfBirth() {
    return this.timeOfBirth;
  }

  @JsonProperty("timeOfBirth")
  public void setTimeOfBirth(Date timeOfBirth) {
    this.timeOfBirth = timeOfBirth;
  }

  @JsonProperty("dateOfBirth")
  public Date getDateOfBirth() {
    return this.dateOfBirth;
  }

  @JsonProperty("dateOfBirth")
  public void setDateOfBirth(Date dateOfBirth) {
    this.dateOfBirth = dateOfBirth;
  }

  @JsonProperty("instantOfBirth")
  public Date getInstantOfBirth() {
    return this.instantOfBirth;
  }

  @JsonProperty("instantOfBirth")
  public void setInstantOfBirth(Date instantOfBirth) {
    this.instantOfBirth = instantOfBirth;
  }

  @JsonProperty("requestTime")
  public Date getRequestTime() {
    return this.requestTime;
  }

  @JsonProperty("requestTime")
  public void setRequestTime(Date requestTime) {
    this.requestTime = requestTime;
  }

  @JsonProperty("actualGender")
  public Gender getActualGender() {
    return this.actualGender;
  }

  @JsonProperty("actualGender")
  public void setActualGender(Gender actualGender) {
    this.actualGender = actualGender;
  }

  @JsonProperty("name")
  public String getName() {
    return this.name;
  }

  @JsonProperty("name")
  public void setName(String name) {
    this.name = name;
  }

  @JsonProperty("weight")
  public Integer getWeight() {
    return this.weight;
  }

  @JsonProperty("weight")
  public void setWeight(Integer weight) {
    this.weight = weight;
  }

  @JsonProperty("siblings")
  public List<Human> getSiblings() {
    return this.siblings;
  }

  @JsonProperty("siblings")
  public void setSiblings(List<Human> siblings) {
    this.siblings = siblings;
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  @JsonAnySetter
  public void setAdditionalProperties(String key, Object value) {
    this.additionalProperties.put(key, value);
  }

  @Override
  public boolean equals(Object o) {
    if (o == null) return false;
    if (this == o) return true;
    if (getClass() != o.getClass()) return false;
    PersonImpl other = (PersonImpl) o;
    return java.util.Objects.equals(this.humanType, other.humanType) && java.util.Objects.equals(this.limbs, other.limbs) && java.util.Objects.equals(this.timeOfArrival, other.timeOfArrival) && java.util.Objects.equals(this.timeOfBirth, other.timeOfBirth) && java.util.Objects.equals(this.dateOfBirth, other.dateOfBirth) && java.util.Objects.equals(this.instantOfBirth, other.instantOfBirth) && java.util.Objects.equals(this.requestTime, other.requestTime) && java.util.Objects.equals(this.actualGender, other.actualGender) && java.util.Objects.equals(this.name, other.name) && java.util.Objects.equals(this.weight, other.weight) && java.util.Objects.equals(this.siblings, other.siblings) && java.util.Objects.equals(this.additionalProperties, other.additionalProperties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(humanType,limbs,timeOfArrival,timeOfBirth,dateOfBirth,instantOfBirth,requestTime,actualGender,name,weight,siblings,additionalProperties);
  }
}
