/*
 * Decompiled with CFR 0.152.
 */
package example.model;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import example.model.Arm;
import example.model.ArmImpl;
import example.model.Leg;
import example.model.LegImpl;
import example.model.LimbImpl;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;

@JsonDeserialize(using=LimbDeserializer.class)
@JsonSerialize(using=Serializer.class)
public interface Limb {
    public Arm getArm();

    public boolean isArm();

    public Leg getLeg();

    public boolean isLeg();

    public static class LimbDeserializer
    extends StdDeserializer<Limb> {
        public LimbDeserializer() {
            super(Limb.class);
        }

        private boolean looksLikeArm(Map<String, Object> map) {
            return map.keySet().containsAll(Arrays.asList("fingers"));
        }

        private boolean looksLikeLeg(Map<String, Object> map) {
            return map.keySet().containsAll(Arrays.asList("toes"));
        }

        public Limb deserialize(JsonParser jsonParser, DeserializationContext jsonContext) throws IOException, JsonProcessingException {
            ObjectMapper mapper = new ObjectMapper();
            Map map = (Map)mapper.readValue(jsonParser, Map.class);
            if (this.looksLikeArm(map)) {
                return new LimbImpl((Arm)mapper.convertValue((Object)map, ArmImpl.class));
            }
            if (this.looksLikeLeg(map)) {
                return new LimbImpl((Leg)mapper.convertValue((Object)map, LegImpl.class));
            }
            throw new IOException("Can't figure out type of object" + map);
        }
    }

    public static class Serializer
    extends StdSerializer<Limb> {
        public Serializer() {
            super(Limb.class);
        }

        public void serialize(Limb object, JsonGenerator jsonGenerator, SerializerProvider jsonSerializerProvider) throws IOException, JsonProcessingException {
            if (object.isArm()) {
                jsonGenerator.writeObject((Object)object.getArm());
                return;
            }
            if (object.isLeg()) {
                jsonGenerator.writeObject((Object)object.getLeg());
                return;
            }
            throw new IOException("Can't figure out type of object" + object);
        }
    }
}

