package example.types;

import example.model.Human;
import example.model.HumanId;
import example.support.ResponseDelegate;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

/**
 * Hello!!!
 */
@Path("/complexhumans")
public interface Complexhumans {
  /**
   * getme
   */
  @GET
  @Produces("application/json")
  @Consumes
  GetComplexhumansResponse getComplexhumans(@QueryParam("id") @Valid HumanId id);

  /**
   */
  @GET
  @Path("/{id}")
  @Produces("application/json")
  @Consumes
  GetComplexhumansByIdResponse getComplexhumansById(@PathParam("id") @Valid HumanId id);

  class GetComplexhumansResponse extends ResponseDelegate {
    private GetComplexhumansResponse(Response response, Object entity) {
      super(response, entity);
    }

    private GetComplexhumansResponse(Response response) {
      super(response);
    }

    /**
     * response
     */
    public static GetComplexhumansResponse respond200WithApplicationJson(Human entity) {
      Response.ResponseBuilder responseBuilder = Response.status(200).header("Content-Type", "application/json");
      responseBuilder.entity(entity);
      return new GetComplexhumansResponse(responseBuilder.build(), entity);
    }
  }

  class GetComplexhumansByIdResponse extends ResponseDelegate {
    private GetComplexhumansByIdResponse(Response response, Object entity) {
      super(response, entity);
    }

    private GetComplexhumansByIdResponse(Response response) {
      super(response);
    }

    public static GetComplexhumansByIdResponse respond200WithApplicationJson(Human entity) {
      Response.ResponseBuilder responseBuilder = Response.status(200).header("Content-Type", "application/json");
      responseBuilder.entity(entity);
      return new GetComplexhumansByIdResponse(responseBuilder.build(), entity);
    }
  }
}
