package example.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Objects;

@JsonDeserialize(
    using = Limb.LimbDeserializer.class
)
@JsonSerialize(
    using = Limb.Serializer.class
)
public class LimbImpl implements Limb {
  private Object anyType;

  private LimbImpl() {
    this.anyType = null;
  }

  public LimbImpl(Arm arm) {
    this.anyType = arm;
  }

  public LimbImpl(Leg leg) {
    this.anyType = leg;
  }

  public Arm getArm() {
    if ( !(anyType instanceof  Arm)) throw new IllegalStateException("fetching wrong type out of the union: example.model.Arm");
    return (Arm) anyType;
  }

  public boolean isArm() {
    return anyType instanceof Arm;
  }

  public Leg getLeg() {
    if ( !(anyType instanceof  Leg)) throw new IllegalStateException("fetching wrong type out of the union: example.model.Leg");
    return (Leg) anyType;
  }

  public boolean isLeg() {
    return anyType instanceof Leg;
  }

  @Override
  public boolean equals(Object o) {
    if (o == null) return false;
    if (this == o) return true;
    if (getClass() != o.getClass()) return false;
    LimbImpl other = (LimbImpl) o;
    return java.util.Objects.equals(this.anyType, other.anyType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(anyType);
  }
}
