package example.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Objects;
import javax.validation.constraints.NotNull;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder("toes")
public class LegImpl implements Leg {
  @JsonProperty("toes")
  @NotNull
  private Integer toes;

  @JsonProperty("toes")
  public Integer getToes() {
    return this.toes;
  }

  @JsonProperty("toes")
  public void setToes(Integer toes) {
    this.toes = toes;
  }

  @Override
  public boolean equals(Object o) {
    if (o == null) return false;
    if (this == o) return true;
    if (getClass() != o.getClass()) return false;
    LegImpl other = (LegImpl) o;
    return java.util.Objects.equals(this.toes, other.toes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(toes);
  }
}
