package example.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonTypeName("corpse")
@JsonPropertyOrder({
    "humanType",
    "limbs",
    "timeOfArrival",
    "timeOfBirth",
    "dateOfBirth",
    "instantOfBirth",
    "requestTime",
    "actualGender",
    "dateOfDeath"
})
public class CorpseImpl implements Corpse {
  @JsonProperty("humanType")
  @NotNull
  private final String humanType = _DISCRIMINATOR_TYPE_NAME;

  @NotNull
  @Valid
  @JsonProperty("limbs")
  private Limb limbs;

  @JsonFormat(
      shape = JsonFormat.Shape.STRING,
      pattern = "yyyy-MM-dd'T'HH:mm:ss"
  )
  @NotNull
  @JsonProperty("timeOfArrival")
  private Date timeOfArrival;

  @JsonFormat(
      shape = JsonFormat.Shape.STRING,
      pattern = "HH:mm:ss"
  )
  @NotNull
  @JsonProperty("timeOfBirth")
  private Date timeOfBirth;

  @JsonFormat(
      shape = JsonFormat.Shape.STRING,
      pattern = "yyyy-MM-dd"
  )
  @NotNull
  @JsonProperty("dateOfBirth")
  private Date dateOfBirth;

  @JsonProperty("instantOfBirth")
  @NotNull
  @JsonFormat(
      shape = JsonFormat.Shape.STRING,
      pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX"
  )
  @JsonDeserialize(
      using = TimestampDeserializer.class
  )
  private Date instantOfBirth;

  @JsonProperty("requestTime")
  @JsonFormat(
      shape = JsonFormat.Shape.STRING,
      pattern = "EEE, dd MMM yyyy HH:mm:ss z"
  )
  @NotNull
  private Date requestTime;

  @JsonProperty("actualGender")
  @NotNull
  private Gender actualGender;

  @JsonFormat(
      shape = JsonFormat.Shape.STRING,
      pattern = "yyyy-MM-dd"
  )
  @NotNull
  @JsonProperty("dateOfDeath")
  private Date dateOfDeath;

  @JsonIgnore
  private Map<String, Object> additionalProperties = new ExcludingMap();

  @JsonProperty("humanType")
  public String getHumanType() {
    return this.humanType;
  }

  @JsonProperty("limbs")
  public Limb getLimbs() {
    return this.limbs;
  }

  @JsonProperty("limbs")
  public void setLimbs(Limb limbs) {
    this.limbs = limbs;
  }

  @JsonProperty("timeOfArrival")
  public Date getTimeOfArrival() {
    return this.timeOfArrival;
  }

  @JsonProperty("timeOfArrival")
  public void setTimeOfArrival(Date timeOfArrival) {
    this.timeOfArrival = timeOfArrival;
  }

  @JsonProperty("timeOfBirth")
  public Date getTimeOfBirth() {
    return this.timeOfBirth;
  }

  @JsonProperty("timeOfBirth")
  public void setTimeOfBirth(Date timeOfBirth) {
    this.timeOfBirth = timeOfBirth;
  }

  @JsonProperty("dateOfBirth")
  public Date getDateOfBirth() {
    return this.dateOfBirth;
  }

  @JsonProperty("dateOfBirth")
  public void setDateOfBirth(Date dateOfBirth) {
    this.dateOfBirth = dateOfBirth;
  }

  @JsonProperty("instantOfBirth")
  public Date getInstantOfBirth() {
    return this.instantOfBirth;
  }

  @JsonProperty("instantOfBirth")
  public void setInstantOfBirth(Date instantOfBirth) {
    this.instantOfBirth = instantOfBirth;
  }

  @JsonProperty("requestTime")
  public Date getRequestTime() {
    return this.requestTime;
  }

  @JsonProperty("requestTime")
  public void setRequestTime(Date requestTime) {
    this.requestTime = requestTime;
  }

  @JsonProperty("actualGender")
  public Gender getActualGender() {
    return this.actualGender;
  }

  @JsonProperty("actualGender")
  public void setActualGender(Gender actualGender) {
    this.actualGender = actualGender;
  }

  @JsonProperty("dateOfDeath")
  public Date getDateOfDeath() {
    return this.dateOfDeath;
  }

  @JsonProperty("dateOfDeath")
  public void setDateOfDeath(Date dateOfDeath) {
    this.dateOfDeath = dateOfDeath;
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  @JsonAnySetter
  public void setAdditionalProperties(String key, Object value) {
    this.additionalProperties.put(key, value);
  }

  @Override
  public boolean equals(Object o) {
    if (o == null) return false;
    if (this == o) return true;
    if (getClass() != o.getClass()) return false;
    CorpseImpl other = (CorpseImpl) o;
    return java.util.Objects.equals(this.humanType, other.humanType) && java.util.Objects.equals(this.limbs, other.limbs) && java.util.Objects.equals(this.timeOfArrival, other.timeOfArrival) && java.util.Objects.equals(this.timeOfBirth, other.timeOfBirth) && java.util.Objects.equals(this.dateOfBirth, other.dateOfBirth) && java.util.Objects.equals(this.instantOfBirth, other.instantOfBirth) && java.util.Objects.equals(this.requestTime, other.requestTime) && java.util.Objects.equals(this.actualGender, other.actualGender) && java.util.Objects.equals(this.dateOfDeath, other.dateOfDeath) && java.util.Objects.equals(this.additionalProperties, other.additionalProperties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(humanType,limbs,timeOfArrival,timeOfBirth,dateOfBirth,instantOfBirth,requestTime,actualGender,dateOfDeath,additionalProperties);
  }
}
