/*
 * Decompiled with CFR 0.152.
 */
package example.types;

import example.model.Human;
import example.model.Person;
import example.support.ResponseDelegate;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;

@Path(value="/humans")
public interface Humans {
    @GET
    @Produces(value={"application/json"})
    public GetHumansResponse getHumans(@QueryParam(value="type") @NotNull String var1);

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public GetHumansByIdResponse getHumansById(@PathParam(value="id") String var1, @QueryParam(value="userType") @NotNull @Size(max=18) String var2);

    @PUT
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    public PutHumansByIdResponse putHumansById(@PathParam(value="id") String var1, Human var2);

    @GET
    @Path(value="/person/{id}")
    @Produces(value={"application/json"})
    public GetHumansPersonByIdResponse getHumansPersonById(@PathParam(value="id") String var1, @QueryParam(value="type") @NotNull String var2);

    public static class GetHumansPersonByIdResponse
    extends ResponseDelegate {
        private GetHumansPersonByIdResponse(Response response, Object entity) {
            super(response, entity);
        }

        private GetHumansPersonByIdResponse(Response response) {
            super(response);
        }

        public static GetHumansPersonByIdResponse respond200WithApplicationJson(Person entity) {
            Response.ResponseBuilder responseBuilder = Response.status((int)200).header("Content-Type", (Object)"application/json");
            responseBuilder.entity((Object)entity);
            return new GetHumansPersonByIdResponse(responseBuilder.build(), entity);
        }
    }

    public static class GetHumansByIdResponse
    extends ResponseDelegate {
        private GetHumansByIdResponse(Response response, Object entity) {
            super(response, entity);
        }

        private GetHumansByIdResponse(Response response) {
            super(response);
        }

        public static GetHumansByIdResponse respond200WithApplicationJson(Human entity) {
            Response.ResponseBuilder responseBuilder = Response.status((int)200).header("Content-Type", (Object)"application/json");
            responseBuilder.entity((Object)entity);
            return new GetHumansByIdResponse(responseBuilder.build(), entity);
        }
    }

    public static class PutHumansByIdResponse
    extends ResponseDelegate {
        private PutHumansByIdResponse(Response response, Object entity) {
            super(response, entity);
        }

        private PutHumansByIdResponse(Response response) {
            super(response);
        }

        public static HeadersFor200 headersFor200() {
            return new HeadersFor200();
        }

        public static PutHumansByIdResponse respond200(HeadersFor200 headers) {
            Response.ResponseBuilder responseBuilder = Response.status((int)200);
            responseBuilder = headers.toResponseBuilder(responseBuilder);
            return new PutHumansByIdResponse(responseBuilder.build());
        }

        public static class HeadersFor200
        extends ResponseDelegate.HeaderBuilderBase {
            private HeadersFor200() {
            }

            public HeadersFor200 withSomeOtherHeader(String p) {
                this.headerMap.put("someOtherHeader", String.valueOf(p));
                return this;
            }
        }
    }

    public static class GetHumansResponse
    extends ResponseDelegate {
        private GetHumansResponse(Response response, Object entity) {
            super(response, entity);
        }

        private GetHumansResponse(Response response) {
            super(response);
        }

        public static HeadersFor200 headersFor200() {
            return new HeadersFor200();
        }

        public static GetHumansResponse respond200WithApplicationJson(List<Human> entity, HeadersFor200 headers) {
            Response.ResponseBuilder responseBuilder = Response.status((int)200).header("Content-Type", (Object)"application/json");
            GenericEntity<List<Human>> wrappedEntity = new GenericEntity<List<Human>>(entity){};
            headers.toResponseBuilder(responseBuilder);
            responseBuilder.entity((Object)wrappedEntity);
            return new GetHumansResponse(responseBuilder.build(), wrappedEntity);
        }

        public static class HeadersFor200
        extends ResponseDelegate.HeaderBuilderBase {
            private HeadersFor200() {
            }

            public HeadersFor200 withBoo(String p) {
                this.headerMap.put("boo", String.valueOf(p));
                return this;
            }

            public HeadersFor200 withSomethingElse(String p) {
                this.headerMap.put("somethingElse", String.valueOf(p));
                return this;
            }
        }
    }
}

