package example.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Map;

@JsonDeserialize(
    as = ArmImpl.class
)
public interface Arm {
  @JsonProperty(
      value = "fingers",
      defaultValue = "5"
  )
  Integer getFingers();

  @JsonProperty(
      value = "fingers",
      defaultValue = "5"
  )
  void setFingers(Integer fingers);

  @JsonAnyGetter
  Map<String, Object> getAdditionalProperties();

  @JsonAnySetter
  void setAdditionalProperties(String key, Object value);
}
