/*
 * Decompiled with CFR 0.152.
 */
package org.raml.emitter;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.raml.api.RamlApi;
import org.raml.api.RamlEntity;
import org.raml.api.RamlFormParameter;
import org.raml.api.RamlHeaderParameter;
import org.raml.api.RamlMediaType;
import org.raml.api.RamlMultiFormDataParameter;
import org.raml.api.RamlParameter;
import org.raml.api.RamlQueryParameter;
import org.raml.api.RamlResource;
import org.raml.api.RamlResourceMethod;
import org.raml.api.RamlSupportedAnnotation;
import org.raml.api.RamlTypes;
import org.raml.emitter.Emitter;
import org.raml.emitter.RamlEmissionException;
import org.raml.emitter.plugins.DefaultResponseHandler;
import org.raml.emitter.plugins.DefaultTypeHandler;
import org.raml.emitter.plugins.ResponseHandler;
import org.raml.jaxrs.common.RamlGenerator;
import org.raml.jaxrs.emitters.AnnotationInstanceEmitter;
import org.raml.jaxrs.emitters.AnnotationTypeEmitter;
import org.raml.jaxrs.emitters.ParameterEmitter;
import org.raml.jaxrs.plugins.TypeHandler;
import org.raml.jaxrs.plugins.TypeSelector;
import org.raml.jaxrs.types.TypeRegistry;
import org.raml.utilities.IndentedAppendable;
import org.raml.utilities.types.Cast;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndentedAppendableEmitter
implements Emitter {
    private static final Logger logger = LoggerFactory.getLogger(IndentedAppendableEmitter.class);
    private TypeRegistry typeRegistry = new TypeRegistry();
    private List<ResponseHandler> responseHandlerAlternatives = Arrays.asList(new DefaultResponseHandler());
    private final IndentedAppendable writer;
    private AnnotationTypeEmitter annotationTypeEmitter;
    private AnnotationInstanceEmitter annotationInstanceEmitter;

    private IndentedAppendableEmitter(IndentedAppendable writer) {
        this.writer = writer;
    }

    public static IndentedAppendableEmitter create(IndentedAppendable appendable) {
        Preconditions.checkNotNull((Object)appendable);
        return new IndentedAppendableEmitter(appendable);
    }

    @Override
    public void emit(RamlApi api) throws RamlEmissionException {
        try {
            this.annotationTypeEmitter = new AnnotationTypeEmitter(this.writer, api.getSupportedAnnotation());
            this.annotationInstanceEmitter = new AnnotationInstanceEmitter(this.writer, api.getSupportedAnnotation());
            this.writeApi(api);
        }
        catch (IOException e) {
            throw new RamlEmissionException(String.format("unable to emit api: %s", api.getBaseUri()), e);
        }
    }

    private void writeApi(RamlApi api) throws IOException {
        this.writeHeader();
        this.writeTitle(api.getTitle());
        this.writeVersion(api.getVersion());
        this.writeBaseUri(api.getBaseUri());
        this.writeDefaultMediaType(api.getDefaultMediaType());
        this.writeSupportedAnnotations(api.getSupportedAnnotation());
        this.writer.deferAppends();
        for (RamlResource resource : api.getResources()) {
            this.writeResource(resource);
        }
        this.writer.stopDeferAppends();
        this.writeTypes();
        this.writer.flushDeferredContent();
    }

    private void writeSupportedAnnotations(List<RamlSupportedAnnotation> supportedAnnotation) throws IOException {
        if (supportedAnnotation.size() == 0) {
            return;
        }
        this.annotationTypeEmitter.emitAnnotations();
    }

    private void writeTypes() throws IOException {
        this.writer.appendLine("types:");
        this.writer.indent();
        this.typeRegistry.writeAll(this.annotationInstanceEmitter, this.writer);
        this.writer.outdent();
    }

    private void writeDefaultMediaType(RamlMediaType defaultMediaType) throws IOException {
        this.writer.appendEscapedLine("mediaType", defaultMediaType.toStringRepresentation());
    }

    private void writeResource(RamlResource resource) throws IOException {
        this.writer.appendLine(String.format("%s:", resource.getPath()));
        this.writer.indent();
        for (RamlResourceMethod method : resource.getMethods()) {
            this.writeMethod(method);
        }
        for (RamlResource child : resource.getChildren()) {
            this.writeResource(child);
        }
        this.writer.outdent();
    }

    private void writeMethod(RamlResourceMethod method) throws IOException {
        this.writer.appendLine(String.format("%s:", method.getHttpMethod()));
        this.writer.indent();
        this.annotationInstanceEmitter.emit(method);
        Optional description = method.getDescription();
        if (description.isPresent() && !((String)description.get()).isEmpty()) {
            this.writeDescription((String)description.get());
        }
        if (!(method.getConsumedMediaTypes().isEmpty() || !method.getConsumedType().isPresent() && method.getMultiFormDataParameter().isEmpty() && method.getFormParameters().isEmpty())) {
            this.writer.appendLine("body:");
            this.writer.indent();
            for (RamlMediaType ramlMediaType : method.getConsumedMediaTypes()) {
                if (ramlMediaType.toStringRepresentation().equals("multipart/form-data")) {
                    this.writer.appendLine(ramlMediaType.toStringRepresentation() + ":");
                    this.writer.indent();
                    this.writeMultiPartFormData(method);
                    this.writer.outdent();
                    continue;
                }
                if (ramlMediaType.toStringRepresentation().equals("application/x-www-form-urlencoded")) {
                    this.writer.appendLine(ramlMediaType.toStringRepresentation() + ":");
                    this.writer.indent();
                    this.writeFormParam(method);
                    this.writer.outdent();
                    continue;
                }
                Type type = ((RamlEntity)method.getConsumedType().get()).getType();
                TypeHandler typeHandler = this.pickTypeHandler(type);
                typeHandler.writeType(this.typeRegistry, this.writer, (RamlEntity)method.getConsumedType().get());
            }
            this.writer.outdent();
        }
        ResponseHandler handler = this.pickResponseHandler(method);
        TypeSelector selector = new TypeSelector(){

            public TypeHandler pickTypeWriter(RamlResourceMethod method, RamlMediaType producedMediaType) throws IOException {
                return IndentedAppendableEmitter.this.pickTypeHandler(((RamlEntity)method.getProducedType().get()).getType());
            }
        };
        if (!method.getProducedMediaTypes().isEmpty()) {
            this.writer.appendLine("responses:");
            this.writer.indent();
            handler.writeResponses(this.typeRegistry, this.writer, method, selector);
            this.writer.outdent();
        }
        if (!method.getHeaderParameters().isEmpty()) {
            this.writeHeaderParameters(method.getHeaderParameters());
        }
        if (!method.getQueryParameters().isEmpty()) {
            this.writeQueryParameters(method.getQueryParameters());
        }
        this.writer.outdent();
    }

    private void writeMultiPartFormData(RamlResourceMethod method) throws IOException {
        this.writer.appendLine("type:");
        this.writer.indent();
        this.writer.appendLine("properties:");
        this.writer.indent();
        List formData = method.getMultiFormDataParameter();
        for (RamlMultiFormDataParameter formDatum : formData) {
            Type type = formDatum.getPartEntity().getType();
            this.writer.appendLine(formDatum.getName() + ":");
            this.writer.indent();
            TypeHandler typeHandler = this.pickTypeHandler(type);
            typeHandler.writeType(this.typeRegistry, this.writer, formDatum.getPartEntity());
            this.writer.outdent();
        }
        this.writer.outdent();
        this.writer.outdent();
    }

    private void writeFormParam(RamlResourceMethod method) throws IOException {
        this.writer.appendLine("type:");
        this.writer.indent();
        this.writer.appendLine("properties:");
        this.writer.indent();
        List formData = method.getFormParameters();
        for (RamlFormParameter formDatum : formData) {
            this.writer.appendLine(formDatum.getName(), RamlTypes.fromType((Type)formDatum.getType()).getRamlSyntax());
        }
        this.writer.outdent();
        this.writer.outdent();
    }

    private TypeHandler pickTypeHandler(Type type) throws IOException {
        Class castClass = Cast.toClass((Type)type);
        RamlGenerator generatorAnnotation = castClass.getAnnotation(RamlGenerator.class);
        if (generatorAnnotation != null) {
            try {
                return (TypeHandler)generatorAnnotation.value().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                logger.error("unable to create generator", (Throwable)e);
                throw new IOException("enable to create generator", e);
            }
        }
        return new DefaultTypeHandler();
    }

    private ResponseHandler pickResponseHandler(final RamlResourceMethod method) {
        Ordering<ResponseHandler> bodies = new Ordering<ResponseHandler>(){

            public int compare(ResponseHandler left, ResponseHandler right) {
                return left.handlesResponses(method) - right.handlesResponses(method);
            }
        };
        return (ResponseHandler)bodies.max(this.responseHandlerAlternatives);
    }

    private void writeDescription(String description) throws IOException {
        this.writer.appendEscapedLine("description", description);
    }

    private void writeHeaderParameters(Iterable<RamlHeaderParameter> headerParameters) throws IOException {
        this.writer.appendLine("headers:");
        this.writer.indent();
        for (RamlHeaderParameter parameter : headerParameters) {
            TypeHandler typeHandler = this.pickTypeHandler(parameter.getEntity().getType());
            ParameterEmitter parameterEmitter = new ParameterEmitter(this.writer, this.typeRegistry, typeHandler);
            parameterEmitter.emit((RamlParameter)parameter);
        }
        this.writer.outdent();
    }

    private void writeQueryParameters(Iterable<RamlQueryParameter> queryParameters) throws IOException {
        this.writer.appendLine("queryParameters:");
        this.writer.indent();
        for (RamlQueryParameter parameter : queryParameters) {
            TypeHandler typeHandler = this.pickTypeHandler(parameter.getEntity().getType());
            ParameterEmitter parameterEmitter = new ParameterEmitter(this.writer, this.typeRegistry, typeHandler);
            parameterEmitter.emit((RamlParameter)parameter);
        }
        this.writer.outdent();
    }

    private void writeHeader() throws IOException {
        this.writer.appendLine("#%RAML 1.0");
    }

    private void writeTitle(String title) throws IOException {
        this.writer.appendEscapedLine("title", title);
    }

    private void writeVersion(String version) throws IOException {
        this.writer.appendEscapedLine("version", version);
    }

    private void writeBaseUri(String baseUri) throws IOException {
        this.writer.appendEscapedLine("baseUri", baseUri);
    }
}

