/*
 * Decompiled with CFR 0.152.
 */
package org.raml.emitter;

import com.google.common.base.Optional;
import com.google.common.collect.ArrayListMultimap;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.raml.api.Annotable;
import org.raml.api.RamlApi;
import org.raml.api.RamlEntity;
import org.raml.api.RamlFormParameter;
import org.raml.api.RamlHeaderParameter;
import org.raml.api.RamlMediaType;
import org.raml.api.RamlMultiFormDataParameter;
import org.raml.api.RamlParameter;
import org.raml.api.RamlQueryParameter;
import org.raml.api.RamlResource;
import org.raml.api.RamlResourceMethod;
import org.raml.api.RamlSupportedAnnotation;
import org.raml.api.RamlTypes;
import org.raml.api.ScalarType;
import org.raml.builder.AnnotableBuilder;
import org.raml.builder.AnnotationTypeBuilder;
import org.raml.builder.BodyBuilder;
import org.raml.builder.MethodBuilder;
import org.raml.builder.NodeBuilder;
import org.raml.builder.NodeBuilders;
import org.raml.builder.ParameterBuilder;
import org.raml.builder.RamlDocumentBuilder;
import org.raml.builder.ResourceBuilder;
import org.raml.builder.TypeBuilder;
import org.raml.builder.TypePropertyBuilder;
import org.raml.emitter.Emitter;
import org.raml.emitter.RamlEmissionException;
import org.raml.emitter.plugins.DefaultResponseHandler;
import org.raml.emitter.plugins.RamlToPojoTypeHandler;
import org.raml.emitter.plugins.ResponseHandler;
import org.raml.jaxrs.emitters.ModelEmitterAnnotations;
import org.raml.jaxrs.emitters.ParameterEmitter;
import org.raml.jaxrs.plugins.TypeHandler;
import org.raml.jaxrs.plugins.TypeSelector;
import org.raml.jaxrs.types.TypeRegistry;
import org.raml.v2.api.model.v10.RamlFragment;
import org.raml.v2.api.model.v10.api.Api;
import org.raml.v2.internal.impl.commons.RamlHeader;
import org.raml.v2.internal.impl.commons.RamlVersion;
import org.raml.yagi.framework.model.NodeModel;
import org.raml.yagi.framework.nodes.ErrorNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.phase.GrammarPhase;

public class ModelEmitter
implements Emitter {
    private TypeRegistry typeRegistry = new TypeRegistry();
    private final List<ResponseHandler> responseHandlerAlternatives = Collections.singletonList(new DefaultResponseHandler());
    private List<RamlSupportedAnnotation> supportedAnnotations;
    private String topPackage;
    private PrintWriter writer;

    public ModelEmitter(PrintWriter writer) {
        this.writer = writer;
    }

    @Override
    public void emit(RamlApi modelApi) throws RamlEmissionException {
        this.supportedAnnotations = modelApi.getSupportedAnnotation();
        this.topPackage = modelApi.getTopPackage();
        org.raml.simpleemitter.Emitter emitter = new org.raml.simpleemitter.Emitter();
        RamlDocumentBuilder documentBuilder = RamlDocumentBuilder.document();
        try {
            documentBuilder.title(modelApi.getTitle()).baseUri(modelApi.getBaseUri()).mediaType(modelApi.getDefaultMediaType().toStringRepresentation()).version(modelApi.getVersion());
            this.annotationTypes(documentBuilder, modelApi);
            this.resources(documentBuilder, modelApi);
            this.typeRegistry.writeAll(this.supportedAnnotations, this.topPackage != null ? Package.getPackage(this.topPackage) : null, documentBuilder);
        }
        catch (IOException e) {
            throw new RamlEmissionException("trying to emit", e);
        }
        Api api = documentBuilder.buildModel();
        GrammarPhase grammarPhase = new GrammarPhase(RamlHeader.getFragmentRule((RamlFragment)new RamlHeader(RamlVersion.RAML_10, RamlFragment.Default).getFragment()));
        Node node = ((NodeModel)api).getNode();
        grammarPhase.apply(node);
        List errors = node.findDescendantsWith(ErrorNode.class);
        for (ErrorNode error : errors) {
            System.err.println("error: " + error.getErrorMessage());
        }
        if (errors.size() == 0) {
            try {
                emitter.emit(api, (Writer)this.writer);
            }
            catch (IOException e) {
                throw new RamlEmissionException("trying to emit", e);
            }
        }
    }

    private void resources(RamlDocumentBuilder builder, RamlApi modelApi) throws IOException {
        for (RamlResource ramlResource : modelApi.getResources()) {
            ResourceBuilder resourceBuilder = this.handleResource(ramlResource);
            builder.with(new NodeBuilder[]{resourceBuilder});
        }
    }

    private void resources(ResourceBuilder builder, RamlResource ramlResource) throws IOException {
        ResourceBuilder resourceBuilder = this.handleResource(ramlResource);
        builder.with(new NodeBuilder[]{resourceBuilder});
    }

    private ResourceBuilder handleResource(RamlResource ramlResource) throws IOException {
        ResourceBuilder resourceBuilder = ResourceBuilder.resource((String)ramlResource.getPath());
        ArrayListMultimap methods = ArrayListMultimap.create();
        for (RamlResourceMethod method : ramlResource.getMethods()) {
            String key = method.getHttpMethod();
            methods.put((Object)key, (Object)method);
        }
        for (String key : methods.keySet()) {
            MethodBuilder methodBuilder = MethodBuilder.method((String)key);
            this.writeMethod(methods.get((Object)key), methodBuilder);
            resourceBuilder.with(new NodeBuilder[]{methodBuilder});
        }
        for (RamlResource child : ramlResource.getChildren()) {
            this.resources(resourceBuilder, child);
        }
        return resourceBuilder;
    }

    private void writeMethod(Collection<RamlResourceMethod> methods, MethodBuilder methodBuilder) throws IOException {
        for (RamlResourceMethod method : methods) {
            ModelEmitterAnnotations.annotate(this.supportedAnnotations, (Annotable)method, (AnnotableBuilder)methodBuilder);
            Optional description = method.getDescription();
            if (description.isPresent() && !((String)description.get()).isEmpty()) {
                methodBuilder.with(new NodeBuilder[]{NodeBuilders.property((String)"description", (String)((String)description.get()))});
            }
            if (!(method.getConsumedMediaTypes().isEmpty() || !method.getConsumedType().isPresent() && method.getMultiFormDataParameter().isEmpty() && method.getFormParameters().isEmpty())) {
                for (RamlMediaType ramlMediaType : method.getConsumedMediaTypes()) {
                    BodyBuilder body = BodyBuilder.body((String)ramlMediaType.toStringRepresentation());
                    methodBuilder.withBodies(new BodyBuilder[]{body});
                    if (ramlMediaType.toStringRepresentation().equals("multipart/form-data")) {
                        this.writeMultiPartFormData(method, body);
                        continue;
                    }
                    if (ramlMediaType.toStringRepresentation().equals("application/x-www-form-urlencoded")) {
                        this.writeFormParam(method, body);
                        continue;
                    }
                    Type type = ((RamlEntity)method.getConsumedType().get()).getType();
                    TypeHandler typeHandler = this.pickTypeHandler(type);
                    body.ofType(typeHandler.writeType(this.typeRegistry, (RamlEntity)method.getConsumedType().get()));
                }
            }
            if (!method.getHeaderParameters().isEmpty()) {
                this.writeHeaderParameters(method.getHeaderParameters(), methodBuilder);
            }
            if (method.getQueryParameters().isEmpty()) continue;
            this.writeQueryParameters(method.getQueryParameters(), methodBuilder);
        }
        ResponseHandler handler = this.pickResponseHandler();
        TypeSelector selector = new TypeSelector(){

            public TypeHandler pickTypeWriter(RamlResourceMethod method, RamlMediaType producedMediaType) throws IOException {
                return ModelEmitter.this.pickTypeHandler(((RamlEntity)method.getProducedType().get()).getType());
            }
        };
        handler.writeResponses(this.typeRegistry, methods, selector, methodBuilder);
    }

    private void writeHeaderParameters(Iterable<RamlHeaderParameter> headerParameters, MethodBuilder builder) throws IOException {
        for (RamlHeaderParameter parameter : headerParameters) {
            TypeHandler typeHandler = this.pickTypeHandler(parameter.getEntity().getType());
            ParameterEmitter parameterEmitter = new ParameterEmitter(this.typeRegistry, typeHandler);
            ParameterBuilder parameterBuilder = parameterEmitter.emit((RamlParameter)parameter);
            builder.withHeaderParameters(new ParameterBuilder[]{parameterBuilder});
        }
    }

    private void writeQueryParameters(Iterable<RamlQueryParameter> queryParameters, MethodBuilder builder) throws IOException {
        for (RamlQueryParameter parameter : queryParameters) {
            TypeHandler typeHandler = this.pickTypeHandler(parameter.getEntity().getType());
            ParameterEmitter parameterEmitter = new ParameterEmitter(this.typeRegistry, typeHandler);
            ParameterBuilder parameterBuilder = parameterEmitter.emit((RamlParameter)parameter);
            builder.withQueryParameter(new ParameterBuilder[]{parameterBuilder});
        }
    }

    private ResponseHandler pickResponseHandler() {
        return this.responseHandlerAlternatives.get(0);
    }

    private void writeFormParam(RamlResourceMethod method, BodyBuilder body) throws IOException {
        TypeBuilder typeBuilder = TypeBuilder.type((String)"object");
        List formData = method.getFormParameters();
        for (RamlFormParameter formDatum : formData) {
            typeBuilder.withProperty(new TypePropertyBuilder[]{TypePropertyBuilder.property((String)formDatum.getName(), (String)RamlTypes.fromType((Type)formDatum.getType()).getRamlSyntax())});
        }
        body.ofType(typeBuilder);
    }

    private void writeMultiPartFormData(RamlResourceMethod method, BodyBuilder body) throws IOException {
        TypeBuilder typeBuilder = TypeBuilder.type((String)"object");
        List formData = method.getMultiFormDataParameter();
        for (RamlMultiFormDataParameter formDatum : formData) {
            Type type = formDatum.getPartEntity().getType();
            TypeHandler typeHandler = this.pickTypeHandler(type);
            typeBuilder.withProperty(new TypePropertyBuilder[]{TypePropertyBuilder.property((String)formDatum.getName(), (TypeBuilder)typeHandler.writeType(this.typeRegistry, formDatum.getPartEntity()))});
        }
        body.ofType(typeBuilder);
    }

    private TypeHandler pickTypeHandler(Type type) throws IOException {
        return new RamlToPojoTypeHandler(this.topPackage != null ? Package.getPackage(this.topPackage) : null);
    }

    private void annotationTypes(RamlDocumentBuilder builder, RamlApi modelApi) throws IOException {
        for (RamlSupportedAnnotation ramlSupportedAnnotation : modelApi.getSupportedAnnotation()) {
            AnnotationTypeBuilder annotationTypeBuilder = AnnotationTypeBuilder.annotationType((String)ramlSupportedAnnotation.getAnnotation().getSimpleName());
            Class javaAnnotation = ramlSupportedAnnotation.getAnnotation();
            if (javaAnnotation.getDeclaredMethods().length <= 0) continue;
            for (Method method : javaAnnotation.getDeclaredMethods()) {
                if (method.getReturnType().isArray()) {
                    annotationTypeBuilder.withProperty(new NodeBuilder[]{NodeBuilders.property((String)method.getName(), (String)(this.calculateRamlType(method.getReturnType().getComponentType()) + "[]"))});
                    continue;
                }
                annotationTypeBuilder.withProperty(new NodeBuilder[]{NodeBuilders.property((String)method.getName(), (String)this.calculateRamlType(method.getReturnType()))});
            }
            builder.withAnnotationTypes(new AnnotationTypeBuilder[]{annotationTypeBuilder});
        }
    }

    private String calculateRamlType(Class<?> type) throws IOException {
        if (Class.class.equals(type)) {
            return "string";
        }
        Optional scalarType = ScalarType.fromType(type);
        if (scalarType.isPresent()) {
            return ((ScalarType)scalarType.get()).getRamlSyntax();
        }
        throw new IOException("invalid type for annotation: " + type);
    }
}

