/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.types;

import com.google.common.base.Optional;
import java.io.IOException;
import java.lang.annotation.Annotation;
import org.raml.api.Annotable;
import org.raml.jaxrs.common.Example;
import org.raml.jaxrs.emitters.AnnotationInstanceEmitter;
import org.raml.jaxrs.emitters.Emittable;
import org.raml.jaxrs.emitters.LocalEmitter;
import org.raml.jaxrs.types.RamlType;
import org.raml.utilities.IndentedAppendable;

public class RamlProperty
implements Emittable,
Annotable {
    private final RamlType ramlType;
    private final String name;
    private final Annotable source;

    public RamlProperty(String name, RamlType ramlType, Annotable source) {
        this.ramlType = ramlType;
        this.name = name;
        this.source = source;
    }

    public String getName() {
        return this.name;
    }

    public static RamlProperty createProperty(Annotable source, String name, RamlType ramlType) {
        return new RamlProperty(name, ramlType, source);
    }

    public void write(AnnotationInstanceEmitter emitter, IndentedAppendable writer) throws IOException {
        writer.appendLine(this.name + ": ");
        writer.indent();
        writer.appendLine("type", this.ramlType.getTypeName());
        emitter.emit(this);
        writer.outdent();
    }

    public void writeExample(IndentedAppendable writer) throws IOException {
        if (!this.ramlType.isRamlScalarType()) {
            writer.appendLine(this.name + ":");
            writer.indent();
            this.ramlType.writeExample(writer);
            writer.outdent();
        } else {
            Optional e = this.source.getAnnotation(Example.class);
            if (!e.isPresent()) {
                return;
            }
            writer.appendLine(this.name + ": " + ((Example)e.get()).value());
        }
    }

    public <T extends Annotation> Optional<T> getAnnotation(Class<T> annotationType) {
        return this.source.getAnnotation(annotationType);
    }

    @Override
    public void emit(LocalEmitter emitter) throws IOException {
        emitter.emit(this);
    }

    public RamlType getRamlType() {
        return this.ramlType;
    }
}

