/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.emitters;

import com.google.common.base.Optional;
import java.io.IOException;
import java.lang.reflect.Type;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.raml.api.RamlParameter;
import org.raml.api.ScalarType;
import org.raml.jaxrs.plugins.TypeHandler;
import org.raml.jaxrs.types.TypeRegistry;
import org.raml.utilities.IndentedAppendable;

public class ParameterEmitter {
    private IndentedAppendable writer;
    private final TypeRegistry typeRegistry;
    private final TypeHandler typeHandler;

    public ParameterEmitter(IndentedAppendable writer, TypeRegistry typeRegistry, TypeHandler typeHandler) {
        this.writer = writer;
        this.typeRegistry = typeRegistry;
        this.typeHandler = typeHandler;
    }

    public void emit(RamlParameter parameter) throws IOException {
        this.writer.appendLine(String.format("%s:", parameter.getName()));
        this.writer.indent();
        this.typeHandler.writeType(this.typeRegistry, this.writer, parameter.getEntity());
        if (parameter.getDefaultValue().isPresent()) {
            this.writer.appendEscapedLine("default", (String)parameter.getDefaultValue().get());
            this.writer.appendLine("required", "false");
        } else if (parameter.getAnnotation(NotNull.class).isPresent()) {
            this.writer.appendLine("required", "true");
        }
        Optional ramlType = ScalarType.fromType((Type)parameter.getEntity().getType());
        if (ramlType.isPresent()) {
            if (ramlType.get() == ScalarType.INTEGER || ramlType.get() == ScalarType.NUMBER) {
                if (parameter.getAnnotation(Min.class).isPresent()) {
                    this.writer.appendLine("minimum", String.valueOf(((Min)parameter.getAnnotation(Min.class).get()).value()));
                }
                if (parameter.getAnnotation(Max.class).isPresent()) {
                    this.writer.appendLine("maximum", String.valueOf(((Max)parameter.getAnnotation(Max.class).get()).value()));
                }
            }
            if (parameter.getAnnotation(Size.class).isPresent() && ramlType.get() == ScalarType.STRING) {
                this.writer.appendLine("minLength", String.valueOf(((Size)parameter.getAnnotation(Size.class).get()).min()));
                this.writer.appendLine("maxLength", String.valueOf(((Size)parameter.getAnnotation(Size.class).get()).max()));
            }
        }
        this.writer.outdent();
    }
}

