/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.handlers;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.raml.api.RamlEntity;
import org.raml.jaxrs.handlers.MethodAnnotable;
import org.raml.jaxrs.handlers.PluginUtilities;
import org.raml.jaxrs.plugins.TypeHandler;
import org.raml.jaxrs.plugins.TypeScanner;
import org.raml.jaxrs.types.RamlProperty;
import org.raml.jaxrs.types.RamlType;
import org.raml.jaxrs.types.TypeRegistry;
import org.raml.utilities.IndentedAppendable;
import org.raml.utilities.types.Cast;

public class BeanLikeTypes
implements TypeHandler {
    @Override
    public void writeType(TypeRegistry registry, IndentedAppendable writer, RamlEntity type) throws IOException {
        this.writeBody(registry, writer, type);
    }

    private void writeBody(TypeRegistry registry, IndentedAppendable writer, RamlEntity bodyType) throws IOException {
        Class topInterface = Cast.toClass((Type)bodyType.getType());
        writer.appendLine("type", topInterface.getSimpleName());
        TypeScanner scanner = new TypeScanner(){

            @Override
            public void scanType(TypeRegistry typeRegistry, RamlEntity typeClass, RamlType ramlType) {
                BeanLikeTypes.this.rebuildType(typeRegistry, typeClass, this);
            }
        };
        scanner.scanType(registry, bodyType, null);
    }

    private RamlType rebuildType(TypeRegistry registry, RamlEntity entity, TypeScanner typeScanner) {
        Class currentInterface = Cast.toClass((Type)entity.getType());
        Class<?>[] interfaces = currentInterface.getInterfaces();
        ArrayList<RamlType> superTypes = new ArrayList<RamlType>();
        for (Class<?> interf : interfaces) {
            superTypes.add(this.rebuildType(registry, entity.createDependent(interf), typeScanner));
        }
        Method[] methods = currentInterface.getDeclaredMethods();
        RamlType rt = registry.registerType(currentInterface.getSimpleName(), entity, typeScanner);
        rt.setSuperTypes(superTypes);
        for (Method method : methods) {
            if (!method.getName().startsWith("get")) continue;
            String badlyCasedfieldName = method.getName().substring(3);
            String fieldName = Character.toLowerCase(badlyCasedfieldName.charAt(0)) + badlyCasedfieldName.substring(1);
            rt.addProperty(RamlProperty.createProperty(new MethodAnnotable(method), fieldName, PluginUtilities.getRamlType(registry, typeScanner, method.getReturnType().getSimpleName(), entity.createDependent(method.getGenericReturnType()))));
        }
        return rt;
    }
}

