/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.handlers;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import java.beans.Introspector;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collection;
import org.raml.api.RamlEntity;
import org.raml.jaxrs.handlers.FieldAnnotable;
import org.raml.jaxrs.handlers.MethodAnnotable;
import org.raml.jaxrs.handlers.PluginUtilities;
import org.raml.jaxrs.plugins.TypeHandler;
import org.raml.jaxrs.plugins.TypeScanner;
import org.raml.jaxrs.types.RamlProperty;
import org.raml.jaxrs.types.RamlType;
import org.raml.jaxrs.types.TypeRegistry;
import org.raml.utilities.IndentedAppendable;
import org.raml.utilities.types.Cast;

public class SimpleJacksonTypes
implements TypeHandler {
    @Override
    public void writeType(TypeRegistry registry, IndentedAppendable writer, RamlEntity type) throws IOException {
        Type javaType = type.getType();
        Class c = Cast.toClass((Type)javaType);
        if (c.isEnum()) {
            this.writeEnum(registry, writer, c, type);
        } else {
            this.writeBody(registry, writer, type);
        }
    }

    private void writeEnum(TypeRegistry registry, IndentedAppendable writer, final Class enumType, RamlEntity entity) throws IOException {
        writer.appendLine("type", enumType.getSimpleName());
        registry.registerType(enumType.getSimpleName(), entity, new TypeScanner(){

            @Override
            public void scanType(TypeRegistry typeRegistry, RamlEntity type, RamlType ramlType) {
                ramlType.setEnumValues((Collection<String>)FluentIterable.of((Object[])enumType.getEnumConstants()).transform((Function)new Function<Object, String>(){

                    public String apply(Object input) {
                        return ((Enum)input).name().toLowerCase();
                    }
                }).toList());
            }
        });
    }

    private void writeBody(TypeRegistry registry, IndentedAppendable writer, RamlEntity bodyType) throws IOException {
        Class type = Cast.toClass((Type)bodyType.getType());
        writer.appendLine("type", type.getSimpleName());
        registry.registerType(type.getSimpleName(), bodyType, new SimpleJacksonTypeScanner());
    }

    private static class SimpleJacksonTypeScanner
    implements TypeScanner {
        private SimpleJacksonTypeScanner() {
        }

        @Override
        public void scanType(TypeRegistry typeRegistry, RamlEntity ramlEntity, RamlType ramlType) {
            Type type = ramlEntity.getType();
            Class c = Cast.toClass((Type)type);
            this.forFields(typeRegistry, ramlEntity, ramlType, c);
            this.forProperties(typeRegistry, ramlEntity, ramlType, c);
        }

        private void forProperties(TypeRegistry typeRegistry, RamlEntity type, RamlType ramlType, Class c) {
            for (Method method : c.getDeclaredMethods()) {
                if (!method.getName().startsWith("get") && !method.getName().startsWith("is") || Modifier.isStatic(method.getModifiers())) continue;
                Type genericType = method.getGenericReturnType();
                RamlType fieldRamlType = PluginUtilities.getRamlType(typeRegistry, this, method.getReturnType().getSimpleName(), type.createDependent(genericType));
                JsonProperty elem = method.getAnnotation(JsonProperty.class);
                if (elem == null) continue;
                String name = elem.value().equals("") ? this.buildName(method) : elem.value();
                ramlType.addProperty(RamlProperty.createProperty(new MethodAnnotable(method), name, fieldRamlType));
            }
        }

        private void forFields(TypeRegistry typeRegistry, RamlEntity type, RamlType ramlType, Class c) {
            for (Field field : c.getDeclaredFields()) {
                Type genericType = field.getGenericType();
                RamlType fieldRamlType = PluginUtilities.getRamlType(typeRegistry, this, field.getType().getSimpleName(), type.createDependent(genericType));
                JsonProperty elem = field.getAnnotation(JsonProperty.class);
                if (elem == null) continue;
                String name = elem.value().equals("") ? field.getName() : elem.value();
                ramlType.addProperty(RamlProperty.createProperty(new FieldAnnotable(field), name, fieldRamlType));
            }
        }

        private String buildName(Method method) {
            if (method.getName().startsWith("is")) {
                return Introspector.decapitalize(method.getName().substring(2));
            }
            return Introspector.decapitalize(method.getName().substring(3));
        }
    }
}

