/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.handlers;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.raml.jaxrs.handlers.PojoToRamlProperty;
import org.raml.pojotoraml.ClassParser;
import org.raml.pojotoraml.Property;

public class SimpleJacksonClassParser
implements ClassParser {
    public List<Property> properties(Class<?> classToParse) {
        TreeMap<String, PojoToRamlProperty> properties = new TreeMap<String, PojoToRamlProperty>();
        this.forFields(classToParse, properties);
        this.forProperties(classToParse, properties);
        return FluentIterable.from(properties.entrySet()).transform((Function)new Function<Map.Entry<String, PojoToRamlProperty>, Property>(){

            @Nullable
            public Property apply(@Nullable Map.Entry<String, PojoToRamlProperty> entry) {
                return entry.getValue();
            }
        }).toList();
    }

    public Collection<Type> parentClasses(Class<?> classToParse) {
        return null;
    }

    private void forProperties(Class<?> classToParse, Map<String, PojoToRamlProperty> propertyMap) {
        for (final Method method : classToParse.getDeclaredMethods()) {
            JsonProperty elem;
            if (!method.getName().startsWith("get") && !method.getName().startsWith("is") || Modifier.isStatic(method.getModifiers()) || (elem = method.getAnnotation(JsonProperty.class)) == null) continue;
            final String name = elem.value().equals("") ? this.buildName(method) : elem.value();
            propertyMap.put(name, new PojoToRamlProperty(){

                public <T extends Annotation> Optional<T> getAnnotation(Class<T> annotationType) {
                    return Optional.fromNullable(method.getAnnotation(annotationType));
                }

                public String name() {
                    return name;
                }

                public Type type() {
                    return method.getGenericReturnType();
                }
            });
        }
    }

    private void forFields(Class<?> classToParse, Map<String, PojoToRamlProperty> propertyMap) {
        for (final Field field : classToParse.getDeclaredFields()) {
            JsonProperty elem = field.getAnnotation(JsonProperty.class);
            if (elem == null) continue;
            final String name = elem.value().equals("") ? field.getName() : elem.value();
            propertyMap.put(name, new PojoToRamlProperty(){

                public <T extends Annotation> Optional<T> getAnnotation(Class<T> annotationType) {
                    return Optional.fromNullable(field.getAnnotation(annotationType));
                }

                public String name() {
                    return name;
                }

                public Type type() {
                    return field.getGenericType();
                }
            });
        }
    }

    private String buildName(Method method) {
        if (method.getName().startsWith("is")) {
            return Introspector.decapitalize(method.getName().substring(2));
        }
        return Introspector.decapitalize(method.getName().substring(3));
    }
}

