/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.handlers;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.raml.jaxrs.handlers.PojoToRamlProperty;
import org.raml.pojotoraml.ClassParser;
import org.raml.pojotoraml.Property;
import org.raml.utilities.types.Cast;

public class SimpleJaxbClassParser
implements ClassParser {
    public List<Property> properties(Class<?> classToParse) {
        TreeMap<String, PojoToRamlProperty> properties = new TreeMap<String, PojoToRamlProperty>();
        Class c = Cast.toClass(classToParse);
        XmlAccessorType accessorType = c.getAnnotation(XmlAccessorType.class);
        XmlAccessType accessType = XmlAccessType.PUBLIC_MEMBER;
        if (accessorType != null) {
            accessType = accessorType.value();
        }
        switch (accessType) {
            case NONE: {
                break;
            }
            case FIELD: {
                this.forFields(classToParse, properties, false);
                this.forProperties(classToParse, properties, true, false);
                break;
            }
            case PROPERTY: {
                this.forProperties(classToParse, properties, false, false);
                this.forFields(classToParse, properties, true);
                break;
            }
            case PUBLIC_MEMBER: {
                this.forProperties(classToParse, properties, false, true);
                this.forFields(classToParse, properties, true);
            }
        }
        return FluentIterable.from(properties.entrySet()).transform((Function)new Function<Map.Entry<String, PojoToRamlProperty>, Property>(){

            @Nullable
            public Property apply(@Nullable Map.Entry<String, PojoToRamlProperty> entry) {
                return entry.getValue();
            }
        }).toList();
    }

    public Collection<Type> parentClasses(Class<?> classToParse) {
        return null;
    }

    private void forProperties(Class<?> classToParse, Map<String, PojoToRamlProperty> properties, boolean explicitOnly, boolean publicOnly) {
        for (Method method : classToParse.getDeclaredMethods()) {
            if (!method.getName().startsWith("get") && !method.getName().startsWith("is") || publicOnly && !Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || method.isAnnotationPresent(XmlTransient.class)) continue;
            Type genericType = method.getGenericReturnType();
            if (explicitOnly && !method.isAnnotationPresent(XmlAttribute.class) && !method.isAnnotationPresent(XmlElement.class)) continue;
            XmlElement elem = method.getAnnotation(XmlElement.class);
            if (elem != null) {
                String name = elem.name().equals("##default") ? this.buildName(method) : elem.name();
                properties.put(name, new MethodPojoToRamlProperty(method, name, genericType));
                continue;
            }
            XmlAttribute attribute = method.getAnnotation(XmlAttribute.class);
            if (attribute != null) {
                String name = elem.name().equals("##default") ? this.buildName(method) : elem.name();
                properties.put(name, new MethodPojoToRamlProperty(method, name, genericType));
                continue;
            }
            properties.put(this.buildName(method), new MethodPojoToRamlProperty(method, this.buildName(method), genericType));
        }
    }

    private void forFields(Class<?> classToParse, Map<String, PojoToRamlProperty> properties, boolean explicitOnly) {
        for (Field field : classToParse.getDeclaredFields()) {
            if (field.isAnnotationPresent(XmlTransient.class) || Modifier.isTransient(field.getModifiers()) || explicitOnly && !field.isAnnotationPresent(XmlAttribute.class) && !field.isAnnotationPresent(XmlElement.class)) continue;
            Type genericType = field.getGenericType();
            XmlElement elem = field.getAnnotation(XmlElement.class);
            if (elem != null) {
                String name = elem.name().equals("##default") ? field.getName() : elem.name();
                properties.put(name, new FieldPojoToRamlProperty(field, name, genericType));
                continue;
            }
            XmlAttribute attribute = field.getAnnotation(XmlAttribute.class);
            if (attribute != null) {
                String name = elem.name().equals("##default") ? field.getName() : elem.name();
                properties.put(name, new FieldPojoToRamlProperty(field, name, genericType));
                continue;
            }
            properties.put(field.getName(), new FieldPojoToRamlProperty(field, field.getName(), genericType));
        }
    }

    private String buildName(Method method) {
        if (method.getName().startsWith("is")) {
            return Introspector.decapitalize(method.getName().substring(2));
        }
        return Introspector.decapitalize(method.getName().substring(3));
    }

    private static class FieldPojoToRamlProperty
    implements PojoToRamlProperty {
        private final Field field;
        private final String name;
        private final Type genericType;

        public FieldPojoToRamlProperty(Field field, String name, Type genericType) {
            this.field = field;
            this.name = name;
            this.genericType = genericType;
        }

        public <T extends Annotation> Optional<T> getAnnotation(Class<T> annotationType) {
            return Optional.fromNullable(this.field.getAnnotation(annotationType));
        }

        public String name() {
            return this.name;
        }

        public Type type() {
            return this.genericType;
        }
    }

    private static class MethodPojoToRamlProperty
    implements PojoToRamlProperty {
        private final Method method;
        private final String name;
        private final Type genericType;

        public MethodPojoToRamlProperty(Method method, String name, Type genericType) {
            this.method = method;
            this.name = name;
            this.genericType = genericType;
        }

        public <T extends Annotation> Optional<T> getAnnotation(Class<T> annotationType) {
            return Optional.fromNullable(this.method.getAnnotation(annotationType));
        }

        public String name() {
            return this.name;
        }

        public Type type() {
            return this.genericType;
        }
    }
}

