/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.emitters;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.raml.builder.ExamplesBuilder;
import org.raml.builder.PropertyValueBuilder;
import org.raml.builder.SupportsProperties;
import org.raml.builder.TypeBuilder;
import org.raml.jaxrs.common.Example;
import org.raml.jaxrs.common.ExampleCases;
import org.raml.jaxrs.common.Examples;
import org.raml.jaxrs.emitters.LocalEmitter;
import org.raml.jaxrs.types.RamlProperty;
import org.raml.jaxrs.types.RamlType;

public class ExampleModelEmitter
implements LocalEmitter {
    private final TypeBuilder typeBuilder;
    private boolean headerDone = false;
    private String currentCaseName;
    private Set<String> seenTypeNames = new HashSet<String>();
    private Stack<SupportsProperties> propertyValues = new Stack();

    public ExampleModelEmitter(TypeBuilder typeBuilder) {
        this.typeBuilder = typeBuilder;
    }

    @Override
    public void emit(RamlType ramlType) throws IOException {
        if (this.seenTypeNames.contains(ramlType.getTypeName())) {
            return;
        }
        this.seenTypeNames.add(ramlType.getTypeName());
        if (!this.headerDone) {
            Optional<ExampleCases> examplesAnnotation = ramlType.getAnnotation(ExampleCases.class);
            if (examplesAnnotation.isPresent()) {
                String[] examples;
                for (String caseName : examples = ((ExampleCases)examplesAnnotation.get()).value()) {
                    if (caseName.isEmpty()) {
                        throw new IOException("@ExampleCases case on type " + ramlType.getTypeName() + " is empty");
                    }
                    this.currentCaseName = caseName;
                    ExamplesBuilder examplesBuilder = ExamplesBuilder.example((String)caseName).strict(false);
                    this.propertyValues.push((SupportsProperties)examplesBuilder);
                    if (this.hasAnExample(ramlType)) {
                        this.emitOneExample(ramlType);
                    } else {
                        examplesBuilder.withNoProperties();
                    }
                    this.typeBuilder.withExamples(new ExamplesBuilder[]{examplesBuilder});
                }
            } else {
                this.currentCaseName = "";
                if (!this.hasAnExample(ramlType)) {
                    return;
                }
                ExamplesBuilder examplesBuilder = ExamplesBuilder.singleExample().strict(false);
                this.propertyValues.push((SupportsProperties)examplesBuilder);
                this.typeBuilder.withExample(examplesBuilder);
                this.headerDone = true;
                this.emitOneExample(ramlType);
            }
        } else {
            this.emitOneExample(ramlType);
        }
    }

    private void emitOneExample(RamlType ramlType) throws IOException {
        for (RamlProperty ramlProperty : ramlType.getProperties()) {
            ramlProperty.emit(this);
        }
    }

    @Override
    public void emit(RamlProperty ramlProperty) throws IOException {
        if (!ramlProperty.isRamlScalarType()) {
            try {
                PropertyValueBuilder property = PropertyValueBuilder.property((String)ramlProperty.getName());
                this.propertyValues.peek().withPropertyValue(property);
                this.propertyValues.push((SupportsProperties)property);
            }
            finally {
                this.propertyValues.pop();
            }
        } else {
            Optional<Example> e = ramlProperty.getAnnotation(Example.class);
            if (e.isPresent() && ((Example)e.get()).useCase().equals(this.currentCaseName)) {
                this.propertyValues.peek().withPropertyValue(PropertyValueBuilder.property((String)ramlProperty.getName(), (String)((Example)e.get()).value()));
                return;
            }
            Optional<Examples> examplesAnnotation = ramlProperty.getAnnotation(Examples.class);
            if (examplesAnnotation.isPresent()) {
                for (Example example : ((Examples)examplesAnnotation.get()).value()) {
                    if (!example.useCase().equals(this.currentCaseName)) continue;
                    this.propertyValues.peek().withPropertyValue(PropertyValueBuilder.property((String)ramlProperty.getName(), (String)example.value()));
                    return;
                }
            }
        }
    }

    private boolean hasAnExample(RamlType type) {
        for (RamlProperty ramlProperty : type.getProperties()) {
            Optional<Example> annotation = ramlProperty.getAnnotation(Example.class);
            if (annotation.isPresent()) {
                return ((Example)annotation.get()).useCase().equals(this.currentCaseName);
            }
            Optional<Examples> examplesAnnotation = ramlProperty.getAnnotation(Examples.class);
            if (!examplesAnnotation.isPresent()) continue;
            for (Example example : ((Examples)examplesAnnotation.get()).value()) {
                if (!example.useCase().equals(this.currentCaseName)) continue;
                return true;
            }
        }
        return false;
    }
}

