/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.emitters;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import org.raml.api.Annotable;
import org.raml.api.RamlSupportedAnnotation;
import org.raml.builder.AnnotableBuilder;
import org.raml.builder.AnnotationBuilder;
import org.raml.builder.PropertyValueBuilder;

public class ModelEmitterAnnotations {
    public static void annotate(Collection<RamlSupportedAnnotation> supportedAnnotations, Annotable annotable, AnnotableBuilder annotableModel) throws IOException {
        for (RamlSupportedAnnotation suportedAnnotation : supportedAnnotations) {
            Optional annotationOptional = suportedAnnotation.getAnnotationInstance(annotable);
            if (!annotationOptional.isPresent()) continue;
            Annotation annotation = (Annotation)annotationOptional.get();
            AnnotationBuilder builder = AnnotationBuilder.annotation((String)annotation.annotationType().getSimpleName());
            if (annotation.annotationType().getDeclaredMethods().length > 0) {
                try {
                    for (Method method : annotation.annotationType().getDeclaredMethods()) {
                        Object value = method.invoke((Object)annotation, new Object[0]);
                        if (value.getClass().isArray()) {
                            ArrayList<Object> list = new ArrayList<Object>();
                            for (int i = 0; i < Array.getLength(value); ++i) {
                                list.add(Array.get(value, i));
                            }
                            String[] listString = (String[])FluentIterable.from(list).transform((Function)new Function<Object, String>(){

                                public String apply(Object input) {
                                    return ModelEmitterAnnotations.toValue(input);
                                }
                            }).toArray(String.class);
                            builder.withProperties(new PropertyValueBuilder[]{PropertyValueBuilder.propertyOfArray((String)method.getName(), (String[])listString)});
                            continue;
                        }
                        builder.withProperties(new PropertyValueBuilder[]{PropertyValueBuilder.property((String)method.getName(), (String)ModelEmitterAnnotations.toValue(value))});
                    }
                }
                catch (Exception e) {
                    throw new IOException("unable to write property", e);
                }
            }
            annotableModel.withAnnotations(new AnnotationBuilder[]{builder});
        }
    }

    private static String toValue(Object value) {
        if (Class.class.isAssignableFrom(value.getClass())) {
            return ((Class)value).getSimpleName();
        }
        return value.toString();
    }
}

