/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.types;

import com.google.common.base.Optional;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.raml.api.Annotable;
import org.raml.api.RamlSupportedAnnotation;
import org.raml.api.ScalarType;
import org.raml.builder.AnnotableBuilder;
import org.raml.builder.RamlDocumentBuilder;
import org.raml.builder.TypeBuilder;
import org.raml.builder.TypeDeclarationBuilder;
import org.raml.builder.TypePropertyBuilder;
import org.raml.jaxrs.emitters.Emittable;
import org.raml.jaxrs.emitters.ExampleModelEmitter;
import org.raml.jaxrs.emitters.LocalEmitter;
import org.raml.jaxrs.emitters.ModelEmitterAnnotations;
import org.raml.jaxrs.types.Descriptor;
import org.raml.jaxrs.types.RamlProperty;
import org.raml.pojotoraml.AdjusterFactory;
import org.raml.pojotoraml.ClassParserFactory;
import org.raml.pojotoraml.PojoToRaml;
import org.raml.pojotoraml.PojoToRamlBuilder;
import org.raml.pojotoraml.Property;
import org.raml.pojotoraml.RamlAdjuster;
import org.raml.pojotoraml.Result;
import org.raml.pojotoraml.plugins.PojoToRamlClassParserFactory;
import org.raml.pojotoraml.plugins.PojoToRamlExtensionFactory;
import org.raml.utilities.tuples.ImmutablePair;
import org.raml.utilities.tuples.Pair;
import org.raml.utilities.types.Cast;

public class RamlType
implements Annotable,
Emittable {
    private static Map<String, RamlType> allTypes = new HashMap<String, RamlType>();
    private static Map<String, TypeBuilder> allBuilders = new HashMap<String, TypeBuilder>();
    private static Map<Type, String> ramlTypeNames = new HashMap<Type, String>();
    private final Type realType;
    private final Descriptor descriptor;
    private Map<String, RamlProperty> properties = new HashMap<String, RamlProperty>();

    public RamlType(Type type, Descriptor descriptor) {
        this.realType = type;
        this.descriptor = descriptor;
    }

    public static Map<String, RamlType> getAllTypes() {
        return allTypes;
    }

    public void addProperty(RamlProperty property) {
        this.properties.put(property.getName(), property);
    }

    public void write(final List<RamlSupportedAnnotation> supportedAnnotations, Package topPackage, RamlDocumentBuilder documentBuilder) throws IOException {
        Type ttype = this.realType;
        Class c = Cast.toClass((Type)ttype);
        final PojoToRamlExtensionFactory toRamlClassParserFactory = new PojoToRamlExtensionFactory(topPackage);
        final ArrayList pojoToRamlProperties = new ArrayList();
        PojoToRaml pojoToRaml = PojoToRamlBuilder.create((ClassParserFactory)new PojoToRamlClassParserFactory(topPackage), (AdjusterFactory)new AdjusterFactory(){

            public RamlAdjuster createAdjuster(Class<?> clazz) {
                RamlAdjuster adjuster = toRamlClassParserFactory.createAdjusters(clazz, new RamlAdjuster[]{new Fixer(supportedAnnotations, pojoToRamlProperties), new RamlAdjuster.Helper(){

                    public TypeBuilder adjustType(Type type, String typeName, TypeBuilder builder) {
                        allTypes.put(typeName, new RamlType(type, new Descriptor(){

                            @Override
                            public Optional<String> describe() {
                                return Optional.absent();
                            }
                        }));
                        allBuilders.put(typeName, builder);
                        ramlTypeNames.put(type, typeName);
                        return super.adjustType(type, typeName, builder);
                    }

                    public TypePropertyBuilder adjustScalarProperty(TypeDeclarationBuilder typeDeclaration, Property property, TypePropertyBuilder typePropertyBuilder) {
                        ((RamlType)allTypes.get(typeDeclaration.id())).addProperty(new RamlProperty(property.name(), new SimpleAnnotable(property), true));
                        return super.adjustScalarProperty(typeDeclaration, property, typePropertyBuilder);
                    }

                    public TypePropertyBuilder adjustComposedProperty(TypeDeclarationBuilder typeDeclaration, Property property, TypePropertyBuilder typePropertyBuilder) {
                        ((RamlType)allTypes.get(typeDeclaration.id())).addProperty(new RamlProperty(property.name(), new SimpleAnnotable(property), true));
                        return super.adjustComposedProperty(typeDeclaration, property, typePropertyBuilder);
                    }
                }});
                return adjuster;
            }
        });
        Result r = pojoToRaml.classToRaml(c);
        if (r.requestedType() != null) {
            documentBuilder.withTypes(new TypeDeclarationBuilder[]{r.requestedType()});
            for (TypeDeclarationBuilder typeDeclarationBuilder : r.dependentTypes()) {
                documentBuilder.withTypes(new TypeDeclarationBuilder[]{typeDeclarationBuilder});
            }
        }
    }

    public String getTypeName() {
        return ramlTypeNames.get(this.realType);
    }

    public <T extends Annotation> Optional<T> getAnnotation(Class<T> annotationType) {
        if (this.realType instanceof Class) {
            return Optional.fromNullable(((Class)this.realType).getAnnotation(annotationType));
        }
        return Optional.absent();
    }

    public boolean isRamlScalarType() {
        Optional st = ScalarType.fromType((Type)this.realType);
        return st.isPresent();
    }

    @Override
    public void emit(LocalEmitter emitter) throws IOException {
        emitter.emit(this);
    }

    public Collection<RamlProperty> getProperties() {
        return this.properties.values();
    }

    public void emitExamples() throws IOException {
        this.emit(new ExampleModelEmitter(allBuilders.get(this.getTypeName())));
    }

    private class Fixer
    extends RamlAdjuster.Helper {
        private final List<RamlSupportedAnnotation> supportedAnnotations;
        private final List<Pair<SimpleAnnotable, TypePropertyBuilder>> pojoToRamlProperties;

        public Fixer(List<RamlSupportedAnnotation> supportedAnnotations, List<Pair<SimpleAnnotable, TypePropertyBuilder>> pojoToRamlProperties) {
            this.supportedAnnotations = supportedAnnotations;
            this.pojoToRamlProperties = pojoToRamlProperties;
        }

        public TypeBuilder adjustType(Type actualType, String typeName, TypeBuilder typeBuilder) {
            try {
                ModelEmitterAnnotations.annotate(this.supportedAnnotations, RamlType.this, (AnnotableBuilder)typeBuilder);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (RamlType.this.descriptor.describe().isPresent()) {
                typeBuilder.description((String)RamlType.this.descriptor.describe().get());
            }
            return typeBuilder;
        }

        public TypePropertyBuilder adjustScalarProperty(TypeDeclarationBuilder typeDeclaration, final Property property, TypePropertyBuilder typePropertyBuilder) {
            try {
                ModelEmitterAnnotations.annotate(this.supportedAnnotations, new Annotable(){

                    public <T extends Annotation> Optional<T> getAnnotation(Class<T> annotationType) {
                        return property.getAnnotation(annotationType);
                    }
                }, (AnnotableBuilder)typePropertyBuilder);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.pojoToRamlProperties.add((Pair<SimpleAnnotable, TypePropertyBuilder>)ImmutablePair.create((Object)new SimpleAnnotable(property), (Object)typePropertyBuilder));
            return typePropertyBuilder;
        }

        public TypePropertyBuilder adjustComposedProperty(TypeDeclarationBuilder typeDeclaration, final Property property, TypePropertyBuilder typePropertyBuilder) {
            try {
                ModelEmitterAnnotations.annotate(this.supportedAnnotations, new Annotable(){

                    public <T extends Annotation> Optional<T> getAnnotation(Class<T> annotationType) {
                        return property.getAnnotation(annotationType);
                    }
                }, (AnnotableBuilder)typePropertyBuilder);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.pojoToRamlProperties.add((Pair<SimpleAnnotable, TypePropertyBuilder>)ImmutablePair.create((Object)new SimpleAnnotable(property), (Object)typePropertyBuilder));
            return typePropertyBuilder;
        }
    }

    private static class SimpleAnnotable
    implements Annotable {
        private final Property property;

        public SimpleAnnotable(Property property) {
            this.property = property;
        }

        public <T extends Annotation> Optional<T> getAnnotation(Class<T> annotationType) {
            return this.property.getAnnotation(annotationType);
        }
    }
}

