/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.ramltojaxrs;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.raml.jaxrs.generator.Configuration;
import org.raml.jaxrs.generator.GenerationException;
import org.raml.jaxrs.generator.RamlScanner;

public class Main {
    public static void main(String[] args) throws IOException, GenerationException, ParseException {
        Options options = new Options();
        options.addOption("m", "model-package", true, "model package");
        options.addOption("s", "support-package", true, "support package");
        options.addOption(Option.builder((String)"r").longOpt("resource-package").hasArg().desc("resource package").build());
        options.addOption("g", "generate-types-with", true, "generate types with plugins (jackson, gson, jaxb, javadoc, jsr303)");
        options.addOption(Option.builder((String)"d").required().longOpt("directory").hasArg().desc("generation directory").build());
        try {
            DefaultParser parser = new DefaultParser();
            CommandLine command = parser.parse(options, args);
            String modelDir = command.getOptionValue("m");
            String supportDir = command.getOptionValue("s");
            String resourceDir = command.getOptionValue("r");
            String directory = command.getOptionValue("d");
            String extensions = command.getOptionValue("g");
            List ramlFiles = command.getArgList();
            Configuration configuration = new Configuration();
            configuration.setModelPackage(modelDir);
            configuration.setResourcePackage(resourceDir);
            configuration.setSupportPackage(supportDir);
            configuration.setOutputDirectory(new File(directory));
            if (extensions != null) {
                configuration.setTypeConfiguration(extensions.split("\\s*,\\s*"));
            }
            RamlScanner scanner = new RamlScanner(configuration);
            for (String ramlFile : ramlFiles) {
                scanner.handle(new File(ramlFile));
            }
        }
        catch (ParseException e) {
            HelpFormatter formatter = new HelpFormatter();
            System.err.println(e.getMessage());
            formatter.printHelp("ramltojaxrs", options, true);
        }
        System.getProperties().remove("ramltojaxrs");
    }
}

