/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.ramltojaxrs;

import com.google.common.base.Optional;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.jsonschema2pojo.AnnotationStyle;
import org.raml.jaxrs.generator.Configuration;
import org.raml.jaxrs.generator.GenerationException;
import org.raml.jaxrs.generator.RamlScanner;

public class Main {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, GenerationException, ParseException {
        Options options = new Options();
        options.addOption("j", "json-mapper", true, "jsonschema2pojo annotation types (jackson, jackson2 or gson)");
        options.addOption("m", "model-package", true, "model package");
        options.addOption("s", "support-package", true, "support package");
        options.addOption("g", "generate-types-with", true, "generate types with plugins (jackson, gson, jaxb, javadoc, jsr303)");
        options.addOption(Option.builder((String)"r").required().longOpt("resource-package").hasArg().desc("resource package").build());
        options.addOption(Option.builder((String)"d").required().longOpt("directory").hasArg().desc("generation directory").build());
        options.addOption(Option.builder((String)"c").longOpt("copy-schemas").build());
        try {
            DefaultParser parser = new DefaultParser();
            CommandLine command = parser.parse(options, args);
            String modelDir = command.getOptionValue("m");
            String supportDir = command.getOptionValue("s");
            String resourceDir = command.getOptionValue("r");
            String directory = command.getOptionValue("d");
            String extensions = command.getOptionValue("g");
            boolean shouldCopySchemas = command.hasOption("c");
            Optional jsonMapper = Optional.fromNullable((Object)command.getOptionValue("j"));
            List ramlFiles = command.getArgList();
            Configuration configuration = new Configuration();
            configuration.setModelPackage(modelDir);
            configuration.setResourcePackage(resourceDir);
            configuration.setSupportPackage(supportDir);
            configuration.setCopySchemas(shouldCopySchemas);
            configuration.setOutputDirectory(new File(directory));
            configuration.setJsonMapper(AnnotationStyle.valueOf((String)((String)jsonMapper.or((Object)"jackson2")).toUpperCase()));
            if (extensions != null) {
                configuration.setTypeConfiguration(extensions.split("\\s*,\\s*"));
            }
            RamlScanner scanner = new RamlScanner(configuration);
            for (String ramlFile : ramlFiles) {
                URLClassLoader ucl = new URLClassLoader(new URL[]{new File(ramlFile).getParentFile().toURL()}, Main.class.getClassLoader());
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(ucl);
                    scanner.handle(new File(ramlFile));
                }
                finally {
                    Thread.currentThread().setContextClassLoader(loader);
                }
            }
        }
        catch (ParseException e) {
            HelpFormatter formatter = new HelpFormatter();
            System.err.println(e.getMessage());
            formatter.printHelp("ramltojaxrs", options, true);
        }
        System.getProperties().remove("ramltojaxrs");
    }
}

