/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.codegen.maven;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.jsonschema2pojo.AnnotationStyle;
import org.raml.jaxrs.codegen.maven.MatchPatternsFileFilter;
import org.raml.jaxrs.generator.Configuration;
import org.raml.jaxrs.generator.RamlScanner;

@Mojo(name="generate", requiresProject=true, threadSafe=false, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class RamlJaxrsCodegenMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}")
    private MavenProject project;
    @Parameter(property="skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="outputDirectory", defaultValue="${project.build.directory}/generated-sources/raml-to-jaxrs-maven-plugin")
    private File outputDirectory;
    @Parameter(property="ramlFile", required=true)
    private File ramlFile;
    @Parameter(property="includes", required=false)
    private String[] includes;
    @Parameter(property="excludes", required=false)
    private String[] excludes;
    @Parameter(property="resourcePackage", required=true)
    private String resourcePackage;
    @Parameter(property="modelPackage")
    private String modelPackage;
    @Parameter(property="supportPackage")
    private String supportPackage;
    @Parameter(property="removeOldOutput", defaultValue="false")
    private boolean removeOldOutput;
    @Parameter(property="generateTypesWith")
    private String[] generateTypesWith;
    @Parameter(property="jsonMapper", defaultValue="jackson2")
    private String jsonMapper;
    @Parameter(property="jsonMapperConfiguration")
    private Map<String, String> jsonMapperConfiguration;
    @Parameter(property="resourceCreationExtension")
    private String resourceCreationExtension;
    @Parameter(property="resourceCreationExtension")
    private String resourceFinishExtension;
    @Parameter(property="typeExtensions")
    private String[] typeExtensions;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution...");
            return;
        }
        if (this.ramlFile == null) {
            throw new MojoExecutionException("ramlFile is not defined");
        }
        try {
            FileUtils.forceMkdir((File)this.outputDirectory);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Failed to create directory: " + this.outputDirectory, (Exception)ioe);
        }
        if (this.removeOldOutput) {
            try {
                FileUtils.cleanDirectory((File)this.outputDirectory);
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Failed to clean directory: " + this.outputDirectory, (Exception)ioe);
            }
        }
        Configuration configuration = new Configuration();
        try {
            Class<?> c;
            configuration.setModelPackage(this.modelPackage);
            configuration.setResourcePackage(this.resourcePackage);
            configuration.setSupportPackage(this.supportPackage);
            configuration.setOutputDirectory(this.outputDirectory);
            configuration.setJsonMapper(AnnotationStyle.valueOf((String)this.jsonMapper.toUpperCase()));
            configuration.setJsonMapperConfiguration(this.jsonMapperConfiguration);
            configuration.setTypeConfiguration(this.generateTypesWith);
            if (this.resourceCreationExtension != null) {
                c = Class.forName(this.resourceCreationExtension);
                configuration.defaultResourceCreationExtension(c);
            }
            if (this.resourceFinishExtension != null) {
                c = Class.forName(this.resourceFinishExtension);
                configuration.defaultResourceFinishExtension(c);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to configure plug-in", e);
        }
        this.project.addCompileSourceRoot(this.outputDirectory.getPath());
        Object currentSourcePath = null;
        try {
            RamlScanner scanner = new RamlScanner(configuration);
            if (this.ramlFile.isDirectory()) {
                MatchPatternsFileFilter filter = new MatchPatternsFileFilter.Builder().addIncludes(this.includes).addExcludes(this.excludes).addDefaultExcludes().withSourceDirectory(this.ramlFile.getCanonicalPath()).withCaseSensitive(false).build();
                Files.walkFileTree(this.ramlFile.toPath(), new PathFileVisitor(scanner, filter));
            } else {
                this.runFile(scanner, this.ramlFile);
            }
            this.getLog().info((CharSequence)("Files generated in " + this.outputDirectory.getAbsolutePath()));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error generating Java classes from: " + currentSourcePath, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runFile(RamlScanner scanner, File ramlFile) throws IOException, DependencyResolutionRequiredException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader newClassLoader = this.getClassLoader(this.project, oldClassLoader, this.getLog(), ramlFile.getParentFile().getAbsoluteFile());
        try {
            Thread.currentThread().setContextClassLoader(newClassLoader);
            scanner.handle(ramlFile);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    private ClassLoader getClassLoader(MavenProject project, final ClassLoader parent, Log log, File file) throws DependencyResolutionRequiredException, MalformedURLException {
        List classpathElements = project.getCompileClasspathElements();
        final ArrayList<URL> classpathUrls = new ArrayList<URL>(classpathElements.size());
        classpathUrls.add(file.toURL());
        for (String classpathElement : classpathElements) {
            try {
                log.debug((CharSequence)("Adding project artifact to classpath: " + classpathElement));
                classpathUrls.add(new File(classpathElement).toURI().toURL());
            }
            catch (MalformedURLException e) {
                log.debug((CharSequence)("Unable to use classpath entry as it could not be understood as a valid URL: " + classpathElement), (Throwable)e);
            }
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return new URLClassLoader(classpathUrls.toArray(new URL[classpathUrls.size()]), parent);
            }
        });
    }

    private class PathFileVisitor
    implements FileVisitor<Path> {
        private final RamlScanner scanner;
        private final MatchPatternsFileFilter filter;

        public PathFileVisitor(RamlScanner scanner, MatchPatternsFileFilter filter) {
            this.scanner = scanner;
            this.filter = filter;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (this.filter.accept(file.toFile())) {
                try {
                    RamlJaxrsCodegenMojo.this.runFile(this.scanner, file.toFile());
                }
                catch (DependencyResolutionRequiredException e) {
                    throw new IOException(e);
                }
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }
    }
}

