package example.references;

import javax.ws.rs.Consumes;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path("/resource1")
public interface Resource1 {
  @PATCH
  @Produces("application/json")
  @Consumes("application/json")
  PatchResource1Response patchResource1(Msg entity);

  class PatchResource1Response extends ResponseDelegate {
    private PatchResource1Response(Response response, Object entity) {
      super(response, entity);
    }

    private PatchResource1Response(Response response) {
      super(response);
    }

    public static PatchResource1Response respond200WithApplicationJson(Object entity) {
      Response.ResponseBuilder responseBuilder = Response.status(200).header("Content-Type", "application/json");
      responseBuilder.entity(entity);
      return new PatchResource1Response(responseBuilder.build(), entity);
    }
  }
}
