package example.references;

import javax.ws.rs.Consumes;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path("/resource2")
public interface Resource2 {
  @PATCH
  @Produces("application/json")
  @Consumes("application/json")
  PatchResource2Response patchResource2(Msg entity);

  class PatchResource2Response extends ResponseDelegate {
    private PatchResource2Response(Response response, Object entity) {
      super(response, entity);
    }

    private PatchResource2Response(Response response) {
      super(response);
    }

    public static PatchResource2Response respond200WithApplicationJson(Object entity) {
      Response.ResponseBuilder responseBuilder = Response.status(200).header("Content-Type", "application/json");
      responseBuilder.entity(entity);
      return new PatchResource2Response(responseBuilder.build(), entity);
    }
  }
}
