package example.xmlschema;

import java.lang.Object;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path("/hr")
public interface Hr {
  @GET
  @Produces("application/xml")
  @Consumes
  GetHrResponse getHr();

  @PUT
  @Consumes("application/xml")
  void putHr(Person entity);

  class GetHrResponse extends ResponseDelegate {
    private GetHrResponse(Response response, Object entity) {
      super(response, entity);
    }

    private GetHrResponse(Response response) {
      super(response);
    }

    public static GetHrResponse respond200WithApplicationXml(Person entity) {
      Response.ResponseBuilder responseBuilder = Response.status(200).header("Content-Type", "application/xml");
      responseBuilder.entity(entity);
      return new GetHrResponse(responseBuilder.build(), entity);
    }
  }
}
