/*
 * Decompiled with CFR 0.152.
 */
package org.raml.utilities;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class IndentedAppendable {
    private static final String END_OF_LINE = System.lineSeparator();
    private final String indent;
    private final Appendable appendable;
    private StringBuilder deferredContent = new StringBuilder();
    private Appendable currentAppendable;
    private String currentIndent = "";

    private IndentedAppendable(String indent, Appendable appendable) {
        this.indent = indent;
        this.appendable = appendable;
        this.currentAppendable = appendable;
    }

    public static IndentedAppendable forNoSpaces(int noSpaces, Appendable appendable) {
        Preconditions.checkArgument((noSpaces >= 0 ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)appendable);
        return new IndentedAppendable(Strings.repeat((String)" ", (int)noSpaces), appendable);
    }

    public void deferAppends() {
        this.currentAppendable = this.deferredContent;
    }

    public void stopDeferAppends() {
        this.currentAppendable = this.appendable;
    }

    public void flushDeferredContent() throws IOException {
        this.appendable.append(this.deferredContent);
        this.deferredContent = new StringBuilder();
    }

    public void indent() {
        this.currentIndent = this.currentIndent + this.indent;
    }

    public void outdent() {
        Preconditions.checkState((!this.currentIndent.isEmpty() ? 1 : 0) != 0, (Object)"outdenting one too many times");
        this.currentIndent = this.currentIndent.substring(0, this.currentIndent.length() - this.indent.length());
    }

    public IndentedAppendable withIndent() throws IOException {
        this.currentAppendable.append(this.currentIndent);
        return this;
    }

    public IndentedAppendable appendLine(String content) throws IOException {
        this.currentAppendable.append(this.currentIndent).append(content).append("\n");
        return this;
    }

    public IndentedAppendable appendLine(String tag, String content) throws IOException {
        this.currentAppendable.append(this.currentIndent).append(tag).append(": ").append(content).append("\n");
        return this;
    }

    public IndentedAppendable appendEscapedLine(String tag, String content) throws IOException {
        return this.appendLine(tag, this.quoteIfSpecialCharacter(content));
    }

    public IndentedAppendable appendList(String tag, String ... content) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        boolean first = true;
        for (String c : content) {
            if (!first) {
                buffer.append(", ");
            }
            first = false;
            buffer.append(this.quoteIfSpecialCharacter(c, true));
        }
        buffer.append("]");
        return this.appendLine(tag, buffer.toString());
    }

    public IndentedAppendable endOfLine() throws IOException {
        this.currentAppendable.append(END_OF_LINE);
        return this;
    }

    public String toString() {
        return this.currentAppendable.toString();
    }

    private String quoteIfSpecialCharacter(String value) {
        return this.quoteIfSpecialCharacter(value, false);
    }

    private String quoteIfSpecialCharacter(String value, boolean inList) {
        boolean escape;
        boolean bl = escape = value != null && (value.matches("[-*|#{}?&!>':%@`,\\[\\]\"].*") || value.matches(".*:.*")) || inList && value.contains(",");
        if (escape) {
            String result = value.replace("\"", "\\\"");
            return "\"" + result + "\"";
        }
        return value;
    }
}

