/*
 * Decompiled with CFR 0.152.
 */
package org.raml.utilities.iterables;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.Iterator;

class SupplierIterator<T>
implements Iterator<T> {
    private final Supplier<? extends T> supplier;

    private SupplierIterator(Supplier<? extends T> supplier) {
        this.supplier = supplier;
    }

    public static <T> SupplierIterator<T> create(Supplier<? extends T> supplier) {
        Preconditions.checkNotNull(supplier);
        return new SupplierIterator<T>(supplier);
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public T next() {
        return (T)this.supplier.get();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("cannot remove on a " + this.getClass().getSimpleName());
    }
}

