/*
 * Decompiled with CFR 0.152.
 */
package org.raml.pojotoraml.plugins;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import javax.annotation.Nullable;
import org.raml.pojotoraml.ClassParser;
import org.raml.pojotoraml.ClassParserFactory;
import org.raml.pojotoraml.field.FieldClassParser;
import org.raml.pojotoraml.plugins.RamlGenerator;
import org.raml.pojotoraml.plugins.RamlGeneratorForClass;
import org.raml.pojotoraml.plugins.RamlGenerators;

public class PojoToRamlClassParserFactory
implements ClassParserFactory {
    private final Package topPackage;

    public PojoToRamlClassParserFactory(Package topPackage) {
        this.topPackage = topPackage;
    }

    @Override
    public ClassParser createParser(final Class<?> clazz) {
        RamlGenerator generator = clazz.getAnnotation(RamlGenerator.class);
        ClassParser parser = null;
        if (generator != null) {
            try {
                parser = generator.parser().newInstance();
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                // empty catch block
            }
        }
        if (parser == null && this.topPackage != null) {
            RamlGenerators generators = this.topPackage.getAnnotation(RamlGenerators.class);
            Optional classParserOptional = FluentIterable.of((Object[])generators.value()).filter((Predicate)new Predicate<RamlGeneratorForClass>(){

                public boolean apply(@Nullable RamlGeneratorForClass ramlGeneratorForClass) {
                    return ramlGeneratorForClass.forClass().equals(clazz);
                }
            }).first().transform((Function)new Function<RamlGeneratorForClass, ClassParser>(){

                @Nullable
                public ClassParser apply(@Nullable RamlGeneratorForClass ramlGeneratorForClass) {
                    try {
                        return ramlGeneratorForClass.generator().parser().newInstance();
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        return null;
                    }
                }
            });
            return (ClassParser)classParserOptional.or((Object)new FieldClassParser());
        }
        return (ClassParser)Optional.fromNullable(parser).or((Object)new FieldClassParser());
    }
}

