/*
 * Decompiled with CFR 0.152.
 */
package org.raml.pojotoraml.field;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.raml.pojotoraml.ClassParser;
import org.raml.pojotoraml.ClassParserFactory;
import org.raml.pojotoraml.Property;
import org.raml.pojotoraml.field.FieldProperty;

public class FieldClassParser
implements ClassParser {
    @Override
    public List<Property> properties(Class<?> sourceClass) {
        ArrayList<Property> props = new ArrayList<Property>();
        for (Field field : sourceClass.getDeclaredFields()) {
            if (Modifier.isTransient(field.getModifiers())) continue;
            FieldProperty prop = new FieldProperty(field);
            props.add(prop);
        }
        return props;
    }

    @Override
    public Collection<Type> parentClasses(Class<?> sourceClass) {
        ArrayList<Type> type = new ArrayList<Type>();
        if (sourceClass.getSuperclass() != Object.class && sourceClass.getSuperclass() != null) {
            type.add(sourceClass.getSuperclass());
        }
        return type;
    }

    public static ClassParserFactory factory() {
        return new ClassParserFactory(){

            @Override
            public ClassParser createParser(Class<?> clazz) {
                return new FieldClassParser();
            }
        };
    }
}

