/*
 * Decompiled with CFR 0.152.
 */
package org.raml.pojotoraml.plugins;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import org.raml.pojotoraml.RamlAdjuster;
import org.raml.pojotoraml.plugins.RamlGenerator;
import org.raml.pojotoraml.plugins.RamlGeneratorForClass;
import org.raml.pojotoraml.plugins.RamlGeneratorPlugin;
import org.raml.pojotoraml.plugins.RamlGenerators;
import org.raml.pojotoraml.util.AnnotationFinder;
import org.raml.ramltopojo.plugin.PluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PojoToRamlExtensionFactory {
    private static PluginManager pluginManager = PluginManager.createPluginManager((String)"META-INF/pojotoraml-plugin.properties");
    private final Package topPackage;
    private static final Logger logger = LoggerFactory.getLogger(PojoToRamlExtensionFactory.class);

    public PojoToRamlExtensionFactory(Package topPackage) {
        this.topPackage = topPackage;
    }

    public RamlAdjuster createAdjusters(final Class<?> clazz, final RamlAdjuster ... ramlAdjusters) {
        RamlGenerator generator = clazz.getAnnotation(RamlGenerator.class);
        if (generator != null) {
            return new RamlAdjuster.Composite((Collection<RamlAdjuster>)FluentIterable.of((Object[])generator.plugins()).transform((Function)new Function<RamlGeneratorPlugin, RamlAdjuster>(){

                @Nullable
                public RamlAdjuster apply(@Nullable RamlGeneratorPlugin ramlGeneratorPlugin) {
                    Set adjuster = pluginManager.getClassesForName(ramlGeneratorPlugin.plugin(), Arrays.asList(ramlGeneratorPlugin.parameters()), RamlAdjuster.class);
                    return new RamlAdjuster.Composite(adjuster);
                }
            }).append((Object[])ramlAdjusters).toList());
        }
        if (this.topPackage != null) {
            RamlGenerators generators = AnnotationFinder.annotationFor(this.topPackage, RamlGenerators.class);
            logger.debug("{} RamlGenerators: {} '{}'\n", new Object[]{"******* ", generators, " *******"});
            Optional ramlAdjusterOptional = FluentIterable.of((Object[])generators.value()).filter((Predicate)new Predicate<RamlGeneratorForClass>(){

                public boolean apply(@Nullable RamlGeneratorForClass ramlGeneratorForClass) {
                    return ramlGeneratorForClass.forClass().equals(clazz);
                }
            }).first().transform((Function)new Function<RamlGeneratorForClass, RamlGenerator>(){

                @Nullable
                public RamlGenerator apply(RamlGeneratorForClass ramlGeneratorForClass) {
                    return ramlGeneratorForClass.generator();
                }
            });
            Optional finalAdjuster = ramlAdjusterOptional.transform((Function)new Function<RamlGenerator, RamlAdjuster>(){

                @Nullable
                public RamlAdjuster apply(RamlGenerator ramlGenerator) {
                    return new RamlAdjuster.Composite((Collection<RamlAdjuster>)FluentIterable.of((Object[])ramlGenerator.plugins()).transform((Function)new Function<RamlGeneratorPlugin, RamlAdjuster>(){

                        public RamlAdjuster apply(RamlGeneratorPlugin ramlGeneratorPlugin) {
                            Set adjuster = pluginManager.getClassesForName(ramlGeneratorPlugin.plugin(), Arrays.asList(ramlGeneratorPlugin.parameters()), RamlAdjuster.class);
                            return new RamlAdjuster.Composite(adjuster);
                        }
                    }).append((Object[])ramlAdjusters).toList());
                }
            });
            return (RamlAdjuster)finalAdjuster.or((Object)new RamlAdjuster.Composite(Arrays.asList(ramlAdjusters)));
        }
        return new RamlAdjuster.Composite(Arrays.asList(ramlAdjusters));
    }
}

