/*
 * Decompiled with CFR 0.152.
 */
package org.raml.pojotoraml.types;

import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import org.raml.pojotoraml.AdjusterFactory;
import org.raml.pojotoraml.ClassParser;
import org.raml.pojotoraml.RamlAdjuster;
import org.raml.pojotoraml.types.CollectionRamlType;
import org.raml.pojotoraml.types.ComposedRamlType;
import org.raml.pojotoraml.types.EnumRamlType;
import org.raml.pojotoraml.types.RamlType;
import org.raml.pojotoraml.types.ScalarType;

public class RamlTypeFactory {
    public static Optional<RamlType> forType(Type type, ClassParser parser, final AdjusterFactory adjusterFactory) {
        Class cls;
        ParameterizedType parameterizedType;
        if (type instanceof ParameterizedType && Collection.class.isAssignableFrom((Class)(parameterizedType = (ParameterizedType)type).getRawType())) {
            if (parameterizedType.getActualTypeArguments().length != 1 && !(parameterizedType.getActualTypeArguments()[0] instanceof Class)) {
                throw new IllegalArgumentException("type " + type + " is not a simple enough type for system to handle:  too many parameters in type or parameter not a class");
            }
            final Class cls2 = (Class)parameterizedType.getActualTypeArguments()[0];
            Optional<RamlType> ramlType = ScalarType.fromType(cls2);
            return Optional.of((Object)CollectionRamlType.of((RamlType)ramlType.or((Supplier)new Supplier<RamlType>(){

                public RamlType get() {
                    RamlAdjuster adjuster = adjusterFactory.createAdjuster(cls2);
                    return ComposedRamlType.forClass(cls2, adjuster.adjustTypeName(cls2, cls2.getSimpleName()));
                }
            })));
        }
        if (type instanceof Class && ((Class)type).isArray()) {
            cls = (Class)type;
            Optional<RamlType> ramlType = ScalarType.fromType(cls.getComponentType());
            return Optional.of((Object)CollectionRamlType.of((RamlType)ramlType.or((Supplier)new Supplier<RamlType>(){

                public RamlType get() {
                    RamlAdjuster adjuster = adjusterFactory.createAdjuster(cls.getComponentType());
                    return ComposedRamlType.forClass(cls.getComponentType(), adjuster.adjustTypeName(cls.getComponentType(), cls.getComponentType().getSimpleName()));
                }
            })));
        }
        if (type instanceof Class && Enum.class.isAssignableFrom((Class)type)) {
            cls = (Class)type;
            RamlAdjuster adjuster = adjusterFactory.createAdjuster(cls);
            return Optional.of((Object)EnumRamlType.forClass(cls, adjuster.adjustTypeName(cls, cls.getSimpleName())));
        }
        if (type instanceof Class) {
            cls = (Class)type;
            Optional<RamlType> ramlType = ScalarType.fromType(cls);
            return Optional.of((Object)ramlType.or((Supplier)new Supplier<RamlType>(){

                public RamlType get() {
                    RamlAdjuster adjuster = adjusterFactory.createAdjuster(cls);
                    return ComposedRamlType.forClass(cls, adjuster.adjustTypeName(cls, cls.getSimpleName()));
                }
            }));
        }
        return Optional.absent();
    }
}

