/*
 * Decompiled with CFR 0.152.
 */
package org.raml.api;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.Map;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;
import org.glassfish.jersey.media.multipart.file.StreamDataBodyPart;
import org.raml.api.RamlType;

public enum ScalarType implements RamlType
{
    NUMBER("number", (Iterable<Type>)ImmutableList.of(Float.TYPE, Float.class, Double.TYPE, Double.class)),
    BOOLEAN("boolean", (Iterable<Type>)ImmutableList.of(Boolean.TYPE, Boolean.class)),
    STRING("string", (Iterable<Type>)ImmutableList.of(String.class)),
    DATE_ONLY("date-only", (Iterable<Type>)ImmutableList.of()),
    TIME_ONLY("time-only", (Iterable<Type>)ImmutableList.of()),
    DATETIME_ONLY("datetime-only", (Iterable<Type>)ImmutableList.of()),
    DATETIME("datetime", (Iterable<Type>)ImmutableList.of()),
    FILE("file", (Iterable<Type>)ImmutableList.of(InputStream.class, FileDataBodyPart.class, StreamDataBodyPart.class)),
    INTEGER("integer", (Iterable<Type>)ImmutableList.of(Integer.TYPE, Integer.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Long.TYPE, Long.class, BigInteger.class)),
    NIL("nil", (Iterable<Type>)ImmutableList.of());

    private static final Map<Type, ScalarType> JAVA_TO_RAML_TYPES;
    private final String ramlSyntax;
    private final Iterable<Type> correspondingJavaTypes;

    private ScalarType(String ramlSyntax, Iterable<Type> correspondingJavaTypes) {
        this.ramlSyntax = ramlSyntax;
        this.correspondingJavaTypes = correspondingJavaTypes;
    }

    @Override
    public String getRamlSyntax() {
        return this.ramlSyntax;
    }

    public static Optional<ScalarType> fromType(Type type) {
        return Optional.fromNullable((Object)JAVA_TO_RAML_TYPES.get(type));
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ScalarType ramlType : ScalarType.values()) {
            for (Type type : ramlType.correspondingJavaTypes) {
                builder.put((Object)type, (Object)ramlType);
            }
        }
        JAVA_TO_RAML_TYPES = builder.build();
    }
}

