/*
 * Decompiled with CFR 0.152.
 */
package org.raml.builder;

import java.util.Arrays;
import org.raml.builder.KeyValueNodeBuilder;
import org.raml.builder.KeyValueNodeBuilderMap;
import org.raml.builder.MethodBuilder;
import org.raml.builder.NodeBuilder;
import org.raml.yagi.framework.nodes.KeyValueNode;

public class ResourceBuilder
extends KeyValueNodeBuilder<ResourceBuilder>
implements NodeBuilder {
    private String displayName;
    private String description;
    private String relativeUri;
    private KeyValueNodeBuilderMap<ResourceBuilder> resourceBuilders = KeyValueNodeBuilderMap.createMap();
    private KeyValueNodeBuilderMap<MethodBuilder> methodBuilders = KeyValueNodeBuilderMap.createMap();

    private ResourceBuilder(String name) {
        super(name);
    }

    public static ResourceBuilder resource(String name) {
        return new ResourceBuilder(name);
    }

    @Override
    public KeyValueNode buildNode() {
        KeyValueNode resourceNode = super.buildNode();
        this.addProperty(resourceNode.getValue(), "displayName", this.displayName);
        this.addProperty(resourceNode.getValue(), "description", this.description);
        this.addProperty(resourceNode.getValue(), "relativeUri", this.relativeUri);
        this.resourceBuilders.addToParent(resourceNode.getValue());
        this.methodBuilders.addToParent(resourceNode.getValue());
        return resourceNode;
    }

    public ResourceBuilder displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public ResourceBuilder description(String comment) {
        this.description = comment;
        return this;
    }

    public ResourceBuilder relativeUri(String relativeUri) {
        this.relativeUri = relativeUri;
        return this;
    }

    public ResourceBuilder withResources(ResourceBuilder ... resourceBuilders) {
        this.resourceBuilders.addAll(Arrays.asList(resourceBuilders));
        return this;
    }

    public ResourceBuilder withMethods(MethodBuilder ... methodBuilders) {
        this.methodBuilders.addAll(Arrays.asList(methodBuilders));
        return this;
    }
}

