/*
 * Decompiled with CFR 0.152.
 */
package org.raml.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.raml.builder.AnnotableBuilder;
import org.raml.builder.AnnotationBuilder;
import org.raml.builder.BodyBuilder;
import org.raml.builder.KeyValueNodeBuilder;
import org.raml.builder.ParameterBuilder;
import org.raml.builder.ResponseBuilder;
import org.raml.yagi.framework.nodes.KeyValueNode;
import org.raml.yagi.framework.nodes.KeyValueNodeImpl;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.ObjectNodeImpl;
import org.raml.yagi.framework.nodes.StringNodeImpl;

public class MethodBuilder
extends KeyValueNodeBuilder<MethodBuilder>
implements AnnotableBuilder<MethodBuilder> {
    private List<ResponseBuilder> responses = new ArrayList<ResponseBuilder>();
    private List<BodyBuilder> bodies = new ArrayList<BodyBuilder>();
    private List<AnnotationBuilder> annotations = new ArrayList<AnnotationBuilder>();
    private List<ParameterBuilder> queryParameters = new ArrayList<ParameterBuilder>();
    private List<ParameterBuilder> headerParameters = new ArrayList<ParameterBuilder>();
    private String description;

    private MethodBuilder(String name) {
        super(name);
    }

    public static MethodBuilder method(String name) {
        return new MethodBuilder(name);
    }

    public MethodBuilder withResponses(ResponseBuilder ... response) {
        this.responses.addAll(Arrays.asList(response));
        return this;
    }

    public MethodBuilder withBodies(BodyBuilder ... builder) {
        this.bodies.addAll(Arrays.asList(builder));
        return this;
    }

    public MethodBuilder withQueryParameter(ParameterBuilder ... builder) {
        this.queryParameters.addAll(Arrays.asList(builder));
        return this;
    }

    public MethodBuilder withHeaderParameters(ParameterBuilder ... builder) {
        this.headerParameters.addAll(Arrays.asList(builder));
        return this;
    }

    @Override
    public MethodBuilder withAnnotations(AnnotationBuilder ... builders) {
        this.annotations.addAll(Arrays.asList(builders));
        return this;
    }

    @Override
    public KeyValueNode buildNode() {
        KeyValueNodeImpl kvn;
        Object responsesValueNode;
        KeyValueNode node = super.buildNode();
        this.addProperty(node.getValue(), "description", this.description);
        if (!this.responses.isEmpty()) {
            responsesValueNode = new ObjectNodeImpl();
            kvn = new KeyValueNodeImpl((Node)new StringNodeImpl("responses"), (Node)responsesValueNode);
            for (ResponseBuilder response : this.responses) {
                responsesValueNode.addChild((Node)response.buildNode());
            }
            node.getValue().addChild((Node)kvn);
        }
        if (!this.queryParameters.isEmpty()) {
            responsesValueNode = new ObjectNodeImpl();
            kvn = new KeyValueNodeImpl((Node)new StringNodeImpl("queryParameters"), (Node)responsesValueNode);
            for (ParameterBuilder queryParameter : this.queryParameters) {
                responsesValueNode.addChild((Node)queryParameter.buildNode());
            }
            node.getValue().addChild((Node)kvn);
        }
        if (!this.headerParameters.isEmpty()) {
            responsesValueNode = new ObjectNodeImpl();
            kvn = new KeyValueNodeImpl((Node)new StringNodeImpl("headers"), (Node)responsesValueNode);
            for (ParameterBuilder quertParameter : this.headerParameters) {
                responsesValueNode.addChild((Node)quertParameter.buildNode());
            }
            node.getValue().addChild((Node)kvn);
        }
        if (!this.annotations.isEmpty()) {
            for (AnnotationBuilder annotation : this.annotations) {
                node.getValue().addChild((Node)annotation.buildNode());
            }
        }
        if (!this.bodies.isEmpty()) {
            ObjectNodeImpl bodyValueNode = new ObjectNodeImpl();
            KeyValueNodeImpl bkvn = new KeyValueNodeImpl((Node)new StringNodeImpl("body"), (Node)bodyValueNode);
            node.getValue().addChild((Node)bkvn);
            for (BodyBuilder body : this.bodies) {
                bodyValueNode.addChild((Node)body.buildNode());
            }
        }
        return node;
    }

    public MethodBuilder description(String description) {
        this.description = description;
        return this;
    }
}

