/*
 * Decompiled with CFR 0.152.
 */
package org.raml.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.raml.builder.AnnotationTypeBuilder;
import org.raml.builder.KeyValueNodeBuilder;
import org.raml.builder.KeyValueNodeBuilderMap;
import org.raml.builder.ModelBuilder;
import org.raml.builder.NodeBuilder;
import org.raml.builder.ResourceBuilder;
import org.raml.builder.TypeDeclarationBuilder;
import org.raml.builder.Util;
import org.raml.v2.api.model.v10.api.Api;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.system.types.ValueType;
import org.raml.v2.internal.impl.commons.model.DefaultModelElement;
import org.raml.v2.internal.impl.commons.model.StringType;
import org.raml.v2.internal.impl.commons.model.factory.TypeDeclarationModelFactory;
import org.raml.v2.internal.impl.commons.nodes.RamlDocumentNode;
import org.raml.yagi.framework.model.DefaultModelBindingConfiguration;
import org.raml.yagi.framework.model.ModelBindingConfiguration;
import org.raml.yagi.framework.model.NodeModel;
import org.raml.yagi.framework.model.NodeModelFactory;
import org.raml.yagi.framework.nodes.KeyValueNodeImpl;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.StringNodeImpl;

public class RamlDocumentBuilder
implements NodeBuilder,
ModelBuilder<Api> {
    private static final ModelBindingConfiguration binding = RamlDocumentBuilder.createV10Binding();
    private List<NodeBuilder> builders = new ArrayList<NodeBuilder>();
    private KeyValueNodeBuilderMap<KeyValueNodeBuilder> annotationTypeBuilders = KeyValueNodeBuilderMap.createMap();
    private KeyValueNodeBuilderMap<KeyValueNodeBuilder> typeDeclarationBuilders = KeyValueNodeBuilderMap.createMap();
    private KeyValueNodeBuilderMap<ResourceBuilder> resourceBuilders = KeyValueNodeBuilderMap.createMap();
    private String baseUri;
    private String title;
    private String version;
    private String mediaType;

    RamlDocumentBuilder() {
    }

    @Override
    public Node buildNode() {
        RamlDocumentNode documentNode = new RamlDocumentNode();
        for (NodeBuilder builder : this.builders) {
            documentNode.addChild(builder.buildNode());
        }
        if (this.baseUri != null) {
            KeyValueNodeImpl baseUriNode = new KeyValueNodeImpl((Node)new StringNodeImpl("baseUri"), (Node)new StringNodeImpl(this.baseUri));
            documentNode.addChild((Node)baseUriNode);
        }
        if (this.title != null) {
            KeyValueNodeImpl titleNode = new KeyValueNodeImpl((Node)new StringNodeImpl("title"), (Node)new StringNodeImpl(this.title));
            documentNode.addChild((Node)titleNode);
        }
        if (this.version != null) {
            KeyValueNodeImpl version = new KeyValueNodeImpl((Node)new StringNodeImpl("version"), (Node)new StringNodeImpl(this.version));
            documentNode.addChild((Node)version);
        }
        if (this.mediaType != null) {
            KeyValueNodeImpl mediaType = new KeyValueNodeImpl((Node)new StringNodeImpl("mediaType"), (Node)new StringNodeImpl(this.mediaType));
            documentNode.addChild((Node)mediaType);
        }
        this.annotationTypeBuilders.addAllToNamedNode("annotationTypes", (Node)documentNode);
        this.typeDeclarationBuilders.addAllToNamedNode("types", (Node)documentNode);
        this.resourceBuilders.addToParent((Node)documentNode);
        return documentNode;
    }

    public RamlDocumentBuilder with(NodeBuilder ... builders) {
        this.builders.addAll(Arrays.asList(builders));
        return this;
    }

    public RamlDocumentBuilder withAnnotationTypes(AnnotationTypeBuilder ... annotationTypeBuilders) {
        this.annotationTypeBuilders.addAll(annotationTypeBuilders);
        return this;
    }

    public RamlDocumentBuilder withTypes(TypeDeclarationBuilder ... typeBuilders) {
        this.typeDeclarationBuilders.addAll(typeBuilders);
        return this;
    }

    public RamlDocumentBuilder withResources(ResourceBuilder ... resourceBuilders) {
        this.resourceBuilders.addAll(resourceBuilders);
        return this;
    }

    @Override
    public Api buildModel() {
        NodeModelFactory fac = binding.bindingOf(Api.class);
        Node node = this.buildNode();
        NodeModel model = fac.create(node);
        return Util.buildModel(binding, node, Api.class);
    }

    private static ModelBindingConfiguration createV10Binding() {
        DefaultModelBindingConfiguration bindingConfiguration = new DefaultModelBindingConfiguration();
        bindingConfiguration.bindPackage("org.raml.v2.internal.impl.commons.model");
        bindingConfiguration.bind(org.raml.v2.api.model.v10.system.types.StringType.class, StringType.class);
        bindingConfiguration.bind(ValueType.class, StringType.class);
        bindingConfiguration.defaultTo(DefaultModelElement.class);
        bindingConfiguration.bind(TypeDeclaration.class, (NodeModelFactory)new TypeDeclarationModelFactory());
        bindingConfiguration.reverseBindPackage("org.raml.v2.api.model.v10.datamodel");
        return bindingConfiguration;
    }

    public static RamlDocumentBuilder document() {
        return new RamlDocumentBuilder();
    }

    public RamlDocumentBuilder baseUri(String baseUri) {
        this.baseUri = baseUri;
        return this;
    }

    public RamlDocumentBuilder title(String title) {
        this.title = title;
        return this;
    }

    public RamlDocumentBuilder version(String version) {
        this.version = version;
        return this;
    }

    public RamlDocumentBuilder mediaType(String mediaType) {
        this.mediaType = mediaType;
        return this;
    }
}

