/*
 * Decompiled with CFR 0.152.
 */
package org.raml.builder;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.raml.builder.AnnotableBuilder;
import org.raml.builder.AnnotationBuilder;
import org.raml.builder.ExamplesBuilder;
import org.raml.builder.FacetBuilder;
import org.raml.builder.NodeBuilder;
import org.raml.builder.NodeBuilders;
import org.raml.builder.ObjectNodeBuilder;
import org.raml.builder.SimpleArrayNode;
import org.raml.builder.SimpleSYArrayNode;
import org.raml.builder.TypePropertyBuilder;
import org.raml.builder.ValueNodeFactories;
import org.raml.builder.ValueNodeFactory;
import org.raml.v2.internal.impl.commons.nodes.FacetNode;
import org.raml.yagi.framework.nodes.ArrayNode;
import org.raml.yagi.framework.nodes.KeyValueNodeImpl;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.ObjectNode;
import org.raml.yagi.framework.nodes.ObjectNodeImpl;
import org.raml.yagi.framework.nodes.StringNodeImpl;

public class TypeBuilder
extends ObjectNodeBuilder<TypeBuilder>
implements NodeBuilder,
AnnotableBuilder<TypeBuilder> {
    private List<TypePropertyBuilder> properties = new ArrayList<TypePropertyBuilder>();
    private List<ExamplesBuilder> examples = new ArrayList<ExamplesBuilder>();
    private List<AnnotationBuilder> annotations = new ArrayList<AnnotationBuilder>();
    private List<FacetBuilder> facets = new ArrayList<FacetBuilder>();
    public String[] types;
    private String description;
    private ValueNodeFactory enumValues;
    private ExamplesBuilder example;
    private TypeBuilder arrayItems;

    private TypeBuilder(String type) {
        this.types = new String[]{type};
    }

    public TypeBuilder(String[] types) {
        this.types = types;
    }

    public TypeBuilder(TypeBuilder builder) {
        this.types = new String[]{"array"};
        this.arrayItems = builder;
    }

    public String id() {
        if (this.types.length == 1) {
            return this.types[0];
        }
        return "[" + Joiner.on((String)",").join((Object[])this.types) + "]";
    }

    public static TypeBuilder type(String type) {
        return new TypeBuilder(type);
    }

    public static TypeBuilder arrayOf(TypeBuilder builder) {
        return new TypeBuilder(builder);
    }

    public static TypeBuilder type() {
        return new TypeBuilder((String[])null);
    }

    public static TypeBuilder type(String ... types) {
        return new TypeBuilder(types);
    }

    @Override
    public TypeBuilder withAnnotations(AnnotationBuilder ... builders) {
        this.annotations.addAll(Arrays.asList(builders));
        return this;
    }

    public TypeBuilder withProperty(TypePropertyBuilder ... properties) {
        this.properties.addAll(Arrays.asList(properties));
        return this;
    }

    public TypeBuilder withExamples(ExamplesBuilder ... properties) {
        this.example = null;
        this.examples.addAll(Arrays.asList(properties));
        return this;
    }

    public TypeBuilder withExample(ExamplesBuilder example) {
        this.examples.clear();
        this.example = example;
        return this;
    }

    public TypeBuilder withFacets(FacetBuilder ... facetBuilders) {
        this.facets.addAll(Arrays.asList(facetBuilders));
        return this;
    }

    public TypeBuilder description(String description) {
        this.description = description;
        return this;
    }

    public TypeBuilder enumValues(String ... enumValues) {
        this.enumValues = ValueNodeFactories.create((ArrayNode)new SimpleSYArrayNode(), enumValues);
        return this;
    }

    public TypeBuilder enumValues(long ... enumValues) {
        this.enumValues = ValueNodeFactories.create((ArrayNode)new SimpleSYArrayNode(), enumValues);
        return this;
    }

    public TypeBuilder enumValues(boolean ... enumValues) {
        this.enumValues = ValueNodeFactories.create((ArrayNode)new SimpleSYArrayNode(), enumValues);
        return this;
    }

    @Override
    public ObjectNode buildNode() {
        KeyValueNodeImpl kvn;
        ObjectNode node = super.buildNode();
        if (this.types != null) {
            if (this.types.length == 1) {
                node.addChild((Node)new KeyValueNodeImpl((Node)new StringNodeImpl("type"), (Node)new StringNodeImpl(this.types[0])));
            } else {
                SimpleArrayNode impl = new SimpleArrayNode();
                for (String type : this.types) {
                    impl.addChild((Node)new StringNodeImpl(type));
                }
                node.addChild((Node)new KeyValueNodeImpl((Node)new StringNodeImpl("type"), (Node)impl));
            }
        }
        if (!this.facets.isEmpty()) {
            kvn = new KeyValueNodeImpl((Node)new StringNodeImpl("facets"), (Node)new ObjectNodeImpl());
            for (FacetBuilder facetBuilder : this.facets) {
                kvn.getValue().addChild((Node)facetBuilder.buildNode());
            }
            node.addChild((Node)kvn);
        }
        if (this.description != null) {
            node.addChild(NodeBuilders.property("description", this.description).buildNode());
        }
        if (this.enumValues != null) {
            FacetNode facetNode = new FacetNode();
            facetNode.addChild((Node)new StringNodeImpl("enum"));
            facetNode.addChild(this.enumValues.createNode());
            node.addChild((Node)facetNode);
        }
        if (!this.annotations.isEmpty()) {
            for (AnnotationBuilder annotation : this.annotations) {
                node.addChild((Node)annotation.buildNode());
            }
        }
        if (!this.properties.isEmpty()) {
            kvn = new KeyValueNodeImpl((Node)new StringNodeImpl("properties"), (Node)new ObjectNodeImpl());
            for (TypePropertyBuilder property : this.properties) {
                kvn.getValue().addChild((Node)property.buildNode());
            }
            node.addChild((Node)kvn);
        }
        if (!this.examples.isEmpty()) {
            kvn = new KeyValueNodeImpl((Node)new StringNodeImpl("examples"), (Node)new ObjectNodeImpl());
            for (ExamplesBuilder example : this.examples) {
                kvn.getValue().addChild((Node)example.buildNode());
            }
        }
        if (this.example != null) {
            KeyValueNodeImpl kvn2 = new KeyValueNodeImpl((Node)new StringNodeImpl("example"), this.example.buildNode().getValue());
            node.addChild((Node)kvn2);
        }
        if (this.arrayItems != null) {
            kvn = new KeyValueNodeImpl((Node)new StringNodeImpl("items"), (Node)this.arrayItems.buildNode());
            node.addChild((Node)kvn);
        }
        return node;
    }
}

