/*
 * Decompiled with CFR 0.152.
 */
package org.raml.builder;

import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.raml.builder.ModelBuilderException;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.api.model.v10.RamlFragment;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.system.types.ValueType;
import org.raml.v2.internal.impl.commons.RamlHeader;
import org.raml.v2.internal.impl.commons.RamlVersion;
import org.raml.v2.internal.impl.commons.grammar.BaseRamlGrammar;
import org.raml.v2.internal.impl.commons.model.DefaultModelElement;
import org.raml.v2.internal.impl.commons.model.StringType;
import org.raml.v2.internal.impl.commons.model.factory.TypeDeclarationModelFactory;
import org.raml.v2.internal.impl.commons.phase.DuplicatedPathsTransformer;
import org.raml.v2.internal.impl.commons.phase.RamlFragmentGrammarTransformer;
import org.raml.v2.internal.impl.commons.phase.ResourceTypesTraitsTransformer;
import org.raml.v2.internal.impl.commons.phase.SchemaValidationTransformer;
import org.raml.v2.internal.impl.commons.phase.TypeValidationPhase;
import org.raml.v2.internal.impl.commons.phase.UnusedParametersTransformer;
import org.raml.v2.internal.impl.v10.grammar.Raml10Grammar;
import org.raml.v2.internal.impl.v10.phase.AnnotationValidationPhase;
import org.raml.v2.internal.impl.v10.phase.ExampleValidationPhase;
import org.raml.v2.internal.impl.v10.phase.MediaTypeInjectionPhase;
import org.raml.v2.internal.impl.v10.phase.ReferenceResolverTransformer;
import org.raml.yagi.framework.model.DefaultModelBindingConfiguration;
import org.raml.yagi.framework.model.ModelBindingConfiguration;
import org.raml.yagi.framework.model.ModelProxyBuilder;
import org.raml.yagi.framework.model.NodeModel;
import org.raml.yagi.framework.model.NodeModelFactory;
import org.raml.yagi.framework.nodes.ErrorNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.phase.GrammarPhase;
import org.raml.yagi.framework.phase.Phase;
import org.raml.yagi.framework.phase.TransformationPhase;
import org.raml.yagi.framework.phase.Transformer;

public class Util {
    public static ModelBindingConfiguration bindingConfiguration() {
        DefaultModelBindingConfiguration bindingConfiguration = new DefaultModelBindingConfiguration();
        bindingConfiguration.bindPackage("org.raml.v2.internal.impl.commons.model");
        bindingConfiguration.bind(org.raml.v2.api.model.v10.system.types.StringType.class, StringType.class);
        bindingConfiguration.bind(ValueType.class, StringType.class);
        bindingConfiguration.defaultTo(DefaultModelElement.class);
        bindingConfiguration.bind(TypeDeclaration.class, (NodeModelFactory)new TypeDeclarationModelFactory());
        bindingConfiguration.reverseBindPackage("org.raml.v2.api.model.v10.datamodel");
        return bindingConfiguration;
    }

    public static <T> T buildModel(ModelBindingConfiguration binding, Node node, Class<T> cls) {
        NodeModelFactory fac = binding.bindingOf(cls);
        NodeModel model = fac.create(node);
        Object m = ModelProxyBuilder.createModel(cls, (NodeModel)model, (ModelBindingConfiguration)binding);
        Phase grammarPhase = Util.createPhases(new ResourceLoader(){

            @Nullable
            public InputStream fetchResource(String resourceName) {
                return null;
            }
        }, new RamlHeader(RamlVersion.RAML_10, RamlFragment.Default).getFragment());
        Node newNode = ((NodeModel)m).getNode();
        grammarPhase.apply(newNode);
        List errors = node.findDescendantsWith(ErrorNode.class);
        if (!errors.isEmpty()) {
            throw new ModelBuilderException(errors);
        }
        return (T)m;
    }

    private static Phase createPhases(ResourceLoader resourceLoader, RamlFragment fragment) {
        final TransformationPhase ramlFragmentsValidator = new TransformationPhase(new Transformer[]{new RamlFragmentGrammarTransformer()});
        final GrammarPhase grammarPhase = new GrammarPhase(RamlHeader.getFragmentRule((RamlFragment)fragment));
        final TransformationPhase referenceCheck = new TransformationPhase(new Transformer[]{new ReferenceResolverTransformer()});
        final TransformationPhase resourcePhase = new TransformationPhase(new Transformer[]{new ResourceTypesTraitsTransformer((BaseRamlGrammar)new Raml10Grammar())});
        final TransformationPhase duplicatedPaths = new TransformationPhase(new Transformer[]{new DuplicatedPathsTransformer()});
        final TransformationPhase checkUnusedParameters = new TransformationPhase(new Transformer[]{new UnusedParametersTransformer()});
        final AnnotationValidationPhase annotationValidationPhase = new AnnotationValidationPhase(resourceLoader);
        final MediaTypeInjectionPhase mediaTypeInjection = new MediaTypeInjectionPhase();
        final TransformationPhase schemaValidationPhase = new TransformationPhase(new Transformer[]{new SchemaValidationTransformer(resourceLoader)});
        final TypeValidationPhase typeValidationPhase = new TypeValidationPhase();
        final ExampleValidationPhase exampleValidationPhase = new ExampleValidationPhase(resourceLoader);
        Phase phase = new Phase(){

            public Node apply(Node tree) {
                List<Phase> phases = Arrays.asList(ramlFragmentsValidator, grammarPhase, referenceCheck, resourcePhase, duplicatedPaths, checkUnusedParameters, annotationValidationPhase, mediaTypeInjection, grammarPhase, schemaValidationPhase, typeValidationPhase, exampleValidationPhase);
                Node node = null;
                for (Phase phase : phases) {
                    node = phase.apply(tree);
                    List descendantsWith = node.findDescendantsWith(ErrorNode.class);
                    if (descendantsWith.size() == 0) continue;
                    throw new ModelBuilderException(descendantsWith);
                }
                return node;
            }
        };
        return phase;
    }
}

