/*
 * Decompiled with CFR 0.152.
 */
package org.raml.builder;

import org.raml.builder.BooleanNode;
import org.raml.builder.NumberNode;
import org.raml.builder.SimpleArrayNode;
import org.raml.builder.ValueNodeFactory;
import org.raml.yagi.framework.nodes.ArrayNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.StringNodeImpl;

public class ValueNodeFactories {
    static ValueNodeFactory create(final long value) {
        return new ValueNodeFactory(){

            @Override
            public Node createNode() {
                return new NumberNode(value);
            }
        };
    }

    static ValueNodeFactory create(final boolean value) {
        return new ValueNodeFactory(){

            @Override
            public Node createNode() {
                return new BooleanNode(value);
            }
        };
    }

    static ValueNodeFactory create(final String value) {
        return new ValueNodeFactory(){

            @Override
            public Node createNode() {
                return new StringNodeImpl(value);
            }
        };
    }

    static ValueNodeFactory create(boolean[] values) {
        return ValueNodeFactories.create((ArrayNode)new SimpleArrayNode(), values);
    }

    static ValueNodeFactory create(long[] values) {
        return ValueNodeFactories.create((ArrayNode)new SimpleArrayNode(), values);
    }

    static ValueNodeFactory create(String[] values) {
        return ValueNodeFactories.create((ArrayNode)new SimpleArrayNode(), values);
    }

    static ValueNodeFactory create(final ArrayNode node, final boolean[] values) {
        return new ValueNodeFactory(){

            @Override
            public Node createNode() {
                for (boolean value : values) {
                    node.addChild((Node)new BooleanNode(value));
                }
                return node;
            }
        };
    }

    static ValueNodeFactory create(final ArrayNode node, final long[] values) {
        return new ValueNodeFactory(){

            @Override
            public Node createNode() {
                for (long value : values) {
                    node.addChild((Node)new NumberNode(value));
                }
                return node;
            }
        };
    }

    static ValueNodeFactory create(final ArrayNode node, final String[] values) {
        return new ValueNodeFactory(){

            @Override
            public Node createNode() {
                for (String value : values) {
                    node.addChild((Node)new StringNodeImpl(value));
                }
                return node;
            }
        };
    }
}

