/*
 * Decompiled with CFR 0.152.
 */
package org.raml.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.raml.builder.BooleanNode;
import org.raml.builder.NodeBuilder;
import org.raml.builder.NumberNode;
import org.raml.yagi.framework.nodes.KeyValueNode;
import org.raml.yagi.framework.nodes.KeyValueNodeImpl;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.ObjectNodeImpl;
import org.raml.yagi.framework.nodes.StringNodeImpl;

public class KeyValueNodeBuilder<B extends KeyValueNodeBuilder>
implements NodeBuilder {
    private final String id;
    private List<NodeBuilder> builders = new ArrayList<NodeBuilder>();

    protected KeyValueNodeBuilder(String name) {
        this.id = name;
    }

    protected KeyValueNodeBuilder(Long value) {
        this.id = value.toString();
    }

    public B with(NodeBuilder ... builders) {
        this.builders.addAll(Arrays.asList(builders));
        return (B)this;
    }

    protected Node createValueNode() {
        return new ObjectNodeImpl();
    }

    protected StringNodeImpl createKeyNode(String id) {
        return new StringNodeImpl(id);
    }

    public KeyValueNode buildNode() {
        Node value = this.createValueNode();
        for (NodeBuilder builder : this.builders) {
            value.addChild(builder.buildNode());
        }
        KeyValueNode container = this.createContainerNode();
        container.addChild((Node)this.createKeyNode(this.id));
        container.addChild(value);
        return container;
    }

    protected KeyValueNode createContainerNode() {
        return new KeyValueNodeImpl();
    }

    public String id() {
        return this.id;
    }

    public void addValueProperty(Node valueNode, String name, String value) {
        if (value != null) {
            ObjectNodeImpl valueHolder = new ObjectNodeImpl();
            this.addProperty((Node)valueHolder, "value", value);
            KeyValueNodeImpl baseUriNode = new KeyValueNodeImpl((Node)new StringNodeImpl(name), (Node)valueHolder);
            valueNode.addChild((Node)baseUriNode);
        }
    }

    public void addProperty(Node valueNode, String name, String value) {
        if (value != null) {
            KeyValueNodeImpl baseUriNode = new KeyValueNodeImpl((Node)new StringNodeImpl(name), (Node)new StringNodeImpl(value));
            valueNode.addChild((Node)baseUriNode);
        }
    }

    public void addProperty(Node valueNode, String name, Boolean value) {
        if (value != null) {
            KeyValueNodeImpl baseUriNode = new KeyValueNodeImpl((Node)new StringNodeImpl(name), (Node)new BooleanNode(value));
            valueNode.addChild((Node)baseUriNode);
        }
    }

    public void addProperty(Node valueNode, String name, Long value) {
        if (value != null) {
            KeyValueNodeImpl baseUriNode = new KeyValueNodeImpl((Node)new StringNodeImpl(name), (Node)new NumberNode(value));
            valueNode.addChild((Node)baseUriNode);
        }
    }
}

