/*
 * Decompiled with CFR 0.152.
 */
package org.raml.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.raml.builder.AnnotableBuilder;
import org.raml.builder.AnnotationBuilder;
import org.raml.builder.KeyValueNodeBuilder;
import org.raml.builder.TypeBuilder;
import org.raml.yagi.framework.nodes.KeyValueNode;
import org.raml.yagi.framework.nodes.Node;

public class TypePropertyBuilder
extends KeyValueNodeBuilder<TypePropertyBuilder>
implements AnnotableBuilder<TypePropertyBuilder> {
    private final TypeBuilder type;
    private Boolean required;
    private List<AnnotationBuilder> annotations = new ArrayList<AnnotationBuilder>();

    public TypePropertyBuilder(String name, TypeBuilder type) {
        super(name);
        this.type = type;
        this.required = true;
    }

    public static TypePropertyBuilder property(String name, String type) {
        return new TypePropertyBuilder(name, TypeBuilder.type(type));
    }

    public static TypePropertyBuilder property(String name, TypeBuilder type) {
        return new TypePropertyBuilder(name, type);
    }

    public TypePropertyBuilder required(boolean required) {
        this.required = required;
        return this;
    }

    @Override
    public TypePropertyBuilder withAnnotations(AnnotationBuilder ... builders) {
        this.annotations.addAll(Arrays.asList(builders));
        return this;
    }

    @Override
    public KeyValueNode buildNode() {
        KeyValueNode node = super.buildNode();
        node.setValue((Node)this.type.buildNode());
        if (!this.required.booleanValue()) {
            this.addProperty(node.getValue(), "required", this.required);
        }
        if (!this.annotations.isEmpty()) {
            for (AnnotationBuilder annotation : this.annotations) {
                node.getValue().addChild((Node)annotation.buildNode());
            }
        }
        return node;
    }
}

