package example.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import example.support.LimbDeserializer;
import example.support.LimbSerializer;
import java.lang.IllegalStateException;

@JsonDeserialize(
    using = LimbDeserializer.class
)
@JsonSerialize(
    using = LimbSerializer.class
)
public class Limb {
  private Arm arm;

  private boolean isArm;

  private Leg leg;

  private boolean isLeg;

  public Limb(Arm arm) {
    this.arm = arm;
    this.isArm = true;
  }

  public Limb(Leg leg) {
    this.leg = leg;
    this.isLeg = true;
  }

  public Arm getArm() {
    if ( isArm == false) throw new IllegalStateException("fetching wrong type out of the union: Arm");
    return arm;
  }

  public boolean isArm() {
    return isArm;
  }

  public Leg getLeg() {
    if ( isLeg == false) throw new IllegalStateException("fetching wrong type out of the union: Leg");
    return leg;
  }

  public boolean isLeg() {
    return isLeg;
  }
}
