package example.types;

import example.model.Human;
import example.support.ResponseDelegate;
import java.lang.String;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path("/humanity")
public interface Humanity {
  @GET
  @Produces("application/json")
  GetHumanityResponse getHumanity(@QueryParam("type") String type);

  @PUT
  @Consumes
  PutHumanityResponse putHumanity(Human entity);

  class GetHumanityResponse extends ResponseDelegate {
    private GetHumanityResponse(Response Response) {
      super(Response);
    }

    public static GetHumanityResponse respond200WithApplicationJson(Human entity) {
      Response.ResponseBuilder responseBuilder = Response.status(200).header("Content-Type", "application/json");
      responseBuilder.entity(entity);
      return new GetHumanityResponse(responseBuilder.build());
    }
  }

  class PutHumanityResponse extends ResponseDelegate {
    private PutHumanityResponse(Response Response) {
      super(Response);
    }

    public static PutHumanityResponse respond200() {
      Response.ResponseBuilder responseBuilder = Response.status(200);
      return new PutHumanityResponse(responseBuilder.build());
    }
  }
}
